/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding.interceptors;

import com.github.mkopylec.charon.forwarding.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;

public class HttpResponse
implements ClientHttpResponse {
    private HttpStatusCode status;
    private HttpHeaders headers;
    private byte[] body;

    public HttpResponse(HttpStatusCode status) {
        this.status = status;
        this.headers = new HttpHeaders();
        this.body = new byte[0];
    }

    HttpResponse(ClientHttpResponse response) throws IOException {
        this.status = response.getStatusCode();
        this.headers = response.getHeaders();
        this.body = IOUtils.toByteArray((InputStream)response.getBody());
        response.close();
    }

    public HttpStatusCode getStatusCode() {
        return this.status;
    }

    public int getRawStatusCode() {
        return this.status.value();
    }

    public String getStatusText() {
        return this.status.toString();
    }

    public void setStatusCode(HttpStatusCode status) {
        this.status = status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public InputStream getBody() {
        return new ByteArrayInputStream(this.body);
    }

    public byte[] getBodyAsBytes() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
        HttpHeaders rewrittenHeaders = Utils.copyHeaders(this.headers);
        rewrittenHeaders.setContentLength((long)body.length);
        this.setHeaders(rewrittenHeaders);
    }

    public void close() {
    }
}

