/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding;

import com.github.mkopylec.charon.configuration.Valid;
import java.time.Duration;
import org.springframework.util.Assert;

public class TimeoutConfiguration
implements Valid {
    private Duration connection = Duration.ofMillis(100L);
    private Duration read = Duration.ofMillis(1000L);
    private Duration write = Duration.ofMillis(500L);

    TimeoutConfiguration() {
    }

    @Override
    public void validate() {
        Assert.notNull((Object)this.connection, (String)"No connection timeout set");
        Assert.isTrue((!this.connection.isNegative() ? 1 : 0) != 0, (String)("Invalid connection timeout value: " + this.connection.toMillis() + " ms"));
        Assert.notNull((Object)this.read, (String)"No read timeout set");
        Assert.isTrue((!this.read.isNegative() ? 1 : 0) != 0, (String)("Invalid read timeout value: " + this.read.toMillis() + " ms"));
        Assert.notNull((Object)this.write, (String)"No write timeout set");
        Assert.isTrue((!this.write.isNegative() ? 1 : 0) != 0, (String)("Invalid write timeout value: " + this.write.toMillis() + " ms"));
    }

    public Duration getConnection() {
        return this.connection;
    }

    void setConnection(Duration connection) {
        this.connection = connection;
    }

    public Duration getRead() {
        return this.read;
    }

    void setRead(Duration read) {
        this.read = read;
    }

    public Duration getWrite() {
        return this.write;
    }

    void setWrite(Duration write) {
        this.write = write;
    }
}

