/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding;

import com.github.mkopylec.charon.configuration.RequestMappingConfiguration;
import com.github.mkopylec.charon.forwarding.HttpRequestMapper;
import com.github.mkopylec.charon.forwarding.HttpResponseMapper;
import com.github.mkopylec.charon.forwarding.RequestMappingResolver;
import com.github.mkopylec.charon.forwarding.RestTemplateProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.filter.OncePerRequestFilter;

public class ReverseProxyFilter
extends OncePerRequestFilter
implements Ordered {
    private int order;
    private RequestMappingResolver requestMappingResolver;
    private HttpRequestMapper httpRequestMapper;
    private RestTemplateProvider restTemplateProvider;
    private HttpResponseMapper httpResponseMapper;

    public ReverseProxyFilter(int order, List<RequestMappingConfiguration> requestMappingConfigurations) {
        this.order = order;
        this.requestMappingResolver = new RequestMappingResolver(requestMappingConfigurations);
        this.httpRequestMapper = new HttpRequestMapper();
        this.restTemplateProvider = new RestTemplateProvider();
        this.httpResponseMapper = new HttpResponseMapper();
    }

    public int getOrder() {
        return this.order;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        RequestMappingConfiguration configuration = this.requestMappingResolver.resolveRequestMapping(request);
        if (configuration == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        RequestEntity<byte[]> requestEntity = this.httpRequestMapper.map(request);
        RestTemplate restTemplate = this.restTemplateProvider.getRestTemplate(configuration);
        ResponseEntity responseEntity = restTemplate.exchange(requestEntity, byte[].class);
        this.httpResponseMapper.map((ResponseEntity<byte[]>)responseEntity, response);
    }
}

