/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding;

import com.github.mkopylec.charon.configuration.RequestMappingConfiguration;
import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.ClientHttpRequestFactoryCreator;
import com.github.mkopylec.charon.forwarding.NoExceptionErrorHandler;
import com.github.mkopylec.charon.forwarding.OkClientHttpRequestFactoryCreatorConfigurer;
import com.github.mkopylec.charon.forwarding.RetryAwareRestTemplate;
import com.github.mkopylec.charon.forwarding.TimeoutConfiguration;
import com.github.mkopylec.charon.forwarding.TimeoutConfigurer;
import com.github.mkopylec.charon.forwarding.interceptors.HttpRequestInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

public class RestTemplateConfiguration
implements Valid {
    private TimeoutConfiguration timeoutConfiguration = TimeoutConfigurer.timeout().configure();
    private ClientHttpRequestFactoryCreator clientHttpRequestFactoryCreator = OkClientHttpRequestFactoryCreatorConfigurer.okClientHttpRequestFactoryCreator().configure();
    private List<ClientHttpRequestInterceptor> clientHttpRequestInterceptors = new ArrayList<ClientHttpRequestInterceptor>();

    RestTemplateConfiguration() {
    }

    void setTimeoutConfiguration(TimeoutConfiguration timeoutConfiguration) {
        this.timeoutConfiguration = timeoutConfiguration;
    }

    void setClientHttpRequestFactoryCreator(ClientHttpRequestFactoryCreator clientHttpRequestFactoryCreator) {
        this.clientHttpRequestFactoryCreator = clientHttpRequestFactoryCreator;
    }

    void setClientHttpRequestInterceptors(List<ClientHttpRequestInterceptor> clientHttpRequestInterceptors) {
        this.clientHttpRequestInterceptors.addAll(clientHttpRequestInterceptors);
    }

    RestTemplate configure(RequestMappingConfiguration configuration) {
        ClientHttpRequestFactory requestFactory = this.clientHttpRequestFactoryCreator.createRequestFactory(this.timeoutConfiguration);
        ArrayList<HttpRequestInterceptor> interceptors = new ArrayList<HttpRequestInterceptor>(this.createHttpRequestInterceptors(configuration));
        interceptors.addAll(this.clientHttpRequestInterceptors);
        RetryAwareRestTemplate restTemplate = new RetryAwareRestTemplate();
        restTemplate.setRequestFactory(requestFactory);
        restTemplate.setErrorHandler(new NoExceptionErrorHandler());
        restTemplate.setInterceptors(interceptors);
        return restTemplate;
    }

    private List<HttpRequestInterceptor> createHttpRequestInterceptors(RequestMappingConfiguration configuration) {
        return configuration.getRequestForwardingInterceptors().stream().map(interceptor -> new HttpRequestInterceptor(configuration.getName(), (RequestForwardingInterceptor)interceptor)).collect(Collectors.toList());
    }
}

