/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding;

import com.github.mkopylec.charon.configuration.RequestMappingConfiguration;
import com.github.mkopylec.charon.forwarding.RequestForwardingException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestMappingResolver {
    private static final Logger log = LoggerFactory.getLogger(RequestMappingResolver.class);
    private List<RequestMappingConfiguration> requestMappingConfigurations;

    RequestMappingResolver(List<RequestMappingConfiguration> requestMappingConfigurations) {
        this.requestMappingConfigurations = requestMappingConfigurations;
    }

    RequestMappingConfiguration resolveRequestMapping(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        List configurations = this.requestMappingConfigurations.stream().filter(configuration -> configuration.getPathRegex().matcher(requestURI).matches()).collect(Collectors.toList());
        if (configurations.isEmpty()) {
            log.debug("No request mapping matches {} incoming request", (Object)requestURI);
            return null;
        }
        RequestForwardingException.requestForwardingErrorIf(configurations.size() > 1, () -> "More than one request mapping matches " + requestURI + " incoming request. Matching mappings are " + configurations.stream().map(RequestMappingConfiguration::toString).collect(Collectors.joining(", ")));
        RequestMappingConfiguration configuration2 = (RequestMappingConfiguration)configurations.get(0);
        log.debug("Request mapping {} matches {} incoming request", (Object)configuration2, (Object)requestURI);
        return configuration2;
    }
}

