/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding;

import com.github.mkopylec.charon.forwarding.ClientHttpRequestFactoryCreator;
import com.github.mkopylec.charon.forwarding.TimeoutConfiguration;
import com.github.mkopylec.charon.forwarding.Utils;
import okhttp3.OkHttpClient;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;

class OkClientHttpRequestFactoryCreator
implements ClientHttpRequestFactoryCreator {
    private OkHttpClient httpClient = new OkHttpClient.Builder().followRedirects(false).followSslRedirects(false).build();

    OkClientHttpRequestFactoryCreator() {
    }

    @Override
    public ClientHttpRequestFactory createRequestFactory(TimeoutConfiguration configuration) {
        OkHttp3ClientHttpRequestFactory requestFactory = new OkHttp3ClientHttpRequestFactory(this.httpClient);
        requestFactory.setConnectTimeout(Utils.toMillis(configuration.getConnection()));
        requestFactory.setReadTimeout(Utils.toMillis(configuration.getRead()));
        requestFactory.setWriteTimeout(Utils.toMillis(configuration.getWrite()));
        return requestFactory;
    }

    void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

