/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.ResponseEntity;

class HttpResponseMapper {
    HttpResponseMapper() {
    }

    void map(ResponseEntity<byte[]> responseEntity, HttpServletResponse response) throws IOException {
        this.setStatus(responseEntity, response);
        this.setHeaders(responseEntity, response);
        this.setBody(responseEntity, response);
    }

    private void setStatus(ResponseEntity<byte[]> responseEntity, HttpServletResponse response) {
        response.setStatus(responseEntity.getStatusCode().value());
    }

    private void setHeaders(ResponseEntity<byte[]> responseEntity, HttpServletResponse response) {
        responseEntity.getHeaders().forEach((name, values) -> values.forEach(value -> response.addHeader(name, value)));
    }

    private void setBody(ResponseEntity<byte[]> responseEntity, HttpServletResponse response) throws IOException {
        if (responseEntity.getBody() != null) {
            response.getOutputStream().write((byte[])responseEntity.getBody());
        }
    }
}

