/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.forwarding;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;

class HttpRequestMapper {
    HttpRequestMapper() {
    }

    RequestEntity<byte[]> map(HttpServletRequest request) throws IOException {
        byte[] body = this.extractBody(request);
        HttpHeaders headers = this.extractHeaders(request);
        HttpMethod method = this.extractMethod(request);
        URI uri = this.extractUri(request);
        return new RequestEntity((Object)body, (MultiValueMap)headers, method, uri);
    }

    private URI extractUri(HttpServletRequest request) {
        String query = request.getQueryString() == null ? "" : "?" + request.getQueryString();
        return URI.create(request.getRequestURL().append(query).toString());
    }

    private HttpMethod extractMethod(HttpServletRequest request) {
        return HttpMethod.valueOf((String)request.getMethod());
    }

    private HttpHeaders extractHeaders(HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            ArrayList value = Collections.list(request.getHeaders(name));
            headers.put(name, value);
        }
        return headers;
    }

    private byte[] extractBody(HttpServletRequest request) throws IOException {
        byte[] body = IOUtils.toByteArray((InputStream)request.getInputStream());
        return (byte[])(body.length != 0 ? body : null);
    }
}

