/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.configuration;

import com.github.mkopylec.charon.configuration.RequestMappingConfigurer;
import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.RestTemplateConfiguration;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.springframework.util.Assert;

public class RequestMappingConfiguration
implements Valid {
    private String name;
    private Pattern pathRegex;
    private RestTemplateConfiguration restTemplateConfiguration;
    private List<RequestForwardingInterceptor> requestForwardingInterceptors;
    private List<RequestForwardingInterceptorType> unsetRequestForwardingInterceptors;
    private RequestMappingConfigurer requestMappingConfigurer;

    RequestMappingConfiguration(String name) {
        this.name = name;
        this.pathRegex = Pattern.compile("/.*");
        this.requestForwardingInterceptors = new ArrayList<RequestForwardingInterceptor>();
        this.unsetRequestForwardingInterceptors = new ArrayList<RequestForwardingInterceptorType>();
    }

    @Override
    public void validate() {
        Assert.hasText((String)this.name, (String)"No request forwarding name set");
    }

    public String getName() {
        return this.name;
    }

    public Pattern getPathRegex() {
        return this.pathRegex;
    }

    void setPathRegex(String pathRegex) {
        this.pathRegex = Pattern.compile(pathRegex);
    }

    public RestTemplateConfiguration getRestTemplateConfiguration() {
        return this.restTemplateConfiguration;
    }

    void setRestTemplateConfiguration(RestTemplateConfiguration restTemplateConfiguration) {
        this.restTemplateConfiguration = restTemplateConfiguration;
    }

    void mergeRestTemplateConfiguration(RestTemplateConfiguration restTemplateConfiguration) {
        if (this.restTemplateConfiguration == null) {
            this.restTemplateConfiguration = restTemplateConfiguration;
        }
    }

    public List<RequestForwardingInterceptor> getRequestForwardingInterceptors() {
        return Collections.unmodifiableList(this.requestForwardingInterceptors);
    }

    void addRequestForwardingInterceptor(RequestForwardingInterceptor requestForwardingInterceptor) {
        this.removeRequestForwardingInterceptor(this.requestForwardingInterceptors, requestForwardingInterceptor.getType());
        this.unsetRequestForwardingInterceptors.remove(requestForwardingInterceptor.getType());
        this.requestForwardingInterceptors.add(requestForwardingInterceptor);
    }

    void removeRequestForwardingInterceptor(RequestForwardingInterceptorType requestForwardingInterceptorType) {
        this.removeRequestForwardingInterceptor(this.requestForwardingInterceptors, requestForwardingInterceptorType);
        this.unsetRequestForwardingInterceptors.add(requestForwardingInterceptorType);
    }

    void mergeRequestForwardingInterceptors(List<RequestForwardingInterceptor> requestForwardingInterceptors) {
        List additionalInterceptors = requestForwardingInterceptors.stream().filter(interceptor -> this.requestForwardingInterceptors.stream().noneMatch(i -> i.getType().equals(interceptor.getType()))).filter(interceptor -> this.unsetRequestForwardingInterceptors.stream().noneMatch(i -> i.equals(interceptor.getType()))).collect(Collectors.toList());
        this.requestForwardingInterceptors.addAll(additionalInterceptors);
        Collections.sort(this.requestForwardingInterceptors);
    }

    RequestMappingConfigurer getRequestMappingConfigurer() {
        return this.requestMappingConfigurer;
    }

    void setRequestMappingConfigurer(RequestMappingConfigurer requestMappingConfigurer) {
        this.requestMappingConfigurer = requestMappingConfigurer;
    }

    private void removeRequestForwardingInterceptor(List<RequestForwardingInterceptor> requestForwardingInterceptors, RequestForwardingInterceptorType requestForwardingInterceptorType) {
        requestForwardingInterceptors.removeIf(interceptor -> interceptor.getType().equals(requestForwardingInterceptorType));
    }

    public String toString() {
        return "'" + this.name + "'";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RequestMappingConfiguration rhs = (RequestMappingConfiguration)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)rhs.name).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }
}

