/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.configuration;

import com.github.mkopylec.charon.configuration.RequestMappingConfiguration;
import com.github.mkopylec.charon.configuration.RequestMappingConfigurer;
import com.github.mkopylec.charon.configuration.Valid;
import com.github.mkopylec.charon.forwarding.RestTemplateConfiguration;
import com.github.mkopylec.charon.forwarding.RestTemplateConfigurer;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptor;
import com.github.mkopylec.charon.forwarding.interceptors.RequestForwardingInterceptorType;
import com.github.mkopylec.charon.forwarding.interceptors.log.ForwardingLoggerConfigurer;
import com.github.mkopylec.charon.forwarding.interceptors.rewrite.RequestProtocolHeadersRewriterConfigurer;
import com.github.mkopylec.charon.forwarding.interceptors.rewrite.RequestProxyHeadersRewriterConfigurer;
import com.github.mkopylec.charon.forwarding.interceptors.rewrite.ResponseProtocolHeadersRewriterConfigurer;
import com.github.mkopylec.charon.forwarding.interceptors.rewrite.RootPathResponseCookiesRewriterConfigurer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CharonConfiguration
implements Valid {
    private int filterOrder = Integer.MIN_VALUE;
    private RestTemplateConfiguration restTemplateConfiguration = (RestTemplateConfiguration)RestTemplateConfigurer.restTemplate().configure();
    private List<RequestForwardingInterceptor> requestForwardingInterceptors = new ArrayList<RequestForwardingInterceptor>();
    private List<RequestMappingConfiguration> requestMappingConfigurations;

    CharonConfiguration() {
        this.addRequestForwardingInterceptor((RequestForwardingInterceptor)ForwardingLoggerConfigurer.forwardingLogger().configure());
        this.addRequestForwardingInterceptor((RequestForwardingInterceptor)RequestProtocolHeadersRewriterConfigurer.requestProtocolHeadersRewriter().configure());
        this.addRequestForwardingInterceptor((RequestForwardingInterceptor)RequestProxyHeadersRewriterConfigurer.requestProxyHeadersRewriter().configure());
        this.addRequestForwardingInterceptor((RequestForwardingInterceptor)ResponseProtocolHeadersRewriterConfigurer.responseProtocolHeadersRewriter().configure());
        this.addRequestForwardingInterceptor((RequestForwardingInterceptor)RootPathResponseCookiesRewriterConfigurer.rootPathResponseCookiesRewriter().configure());
        this.requestMappingConfigurations = new ArrayList<RequestMappingConfiguration>();
    }

    int getFilterOrder() {
        return this.filterOrder;
    }

    void setFilterOrder(int filterOrder) {
        this.filterOrder = filterOrder;
    }

    void setRestTemplateConfiguration(RestTemplateConfiguration restTemplateConfiguration) {
        this.restTemplateConfiguration = restTemplateConfiguration;
    }

    void addRequestForwardingInterceptor(RequestForwardingInterceptor requestForwardingInterceptor) {
        this.removeRequestForwardingInterceptor(requestForwardingInterceptor.getType());
        this.requestForwardingInterceptors.add(requestForwardingInterceptor);
    }

    void removeRequestForwardingInterceptor(RequestForwardingInterceptorType requestForwardingInterceptorType) {
        this.requestForwardingInterceptors.removeIf(interceptor -> interceptor.getType().equals(requestForwardingInterceptorType));
    }

    List<RequestMappingConfiguration> getRequestMappingConfigurations() {
        return Collections.unmodifiableList(this.requestMappingConfigurations);
    }

    RequestMappingConfigurer getRequestMappingConfigurer(String requestMappingName) {
        return this.requestMappingConfigurations.stream().filter(configuration -> configuration.getName().equals(requestMappingName)).findFirst().map(RequestMappingConfiguration::getRequestMappingConfigurer).orElse(null);
    }

    void addRequestMappingConfiguration(RequestMappingConfiguration requestMappingConfiguration) {
        this.requestMappingConfigurations.remove(requestMappingConfiguration);
        this.requestMappingConfigurations.add(requestMappingConfiguration);
    }

    void mergeWithRequestMappingConfigurations() {
        this.requestMappingConfigurations.forEach(configuration -> {
            configuration.mergeRestTemplateConfiguration(this.restTemplateConfiguration);
            configuration.mergeRequestForwardingInterceptors(this.requestForwardingInterceptors);
        });
    }
}

