/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.configuration;

import com.github.mkopylec.charon.configuration.CharonConfiguration;
import com.github.mkopylec.charon.configuration.CharonConfigurer;
import com.github.mkopylec.charon.forwarding.ReverseProxyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnBean(value={CharonConfigurer.class})
class CharonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CharonAutoConfiguration.class);

    CharonAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    ReverseProxyFilter reverseProxyFilter(ObjectProvider<CharonConfigurer> charonConfigurer) {
        CharonConfigurer configurer = (CharonConfigurer)charonConfigurer.getIfAvailable();
        if (configurer == null) {
            log.warn("No Charon configuration detected, all incoming requests will be handled locally");
            configurer = CharonConfigurer.charonConfiguration();
        }
        CharonConfiguration configuration = configurer.configure();
        return new ReverseProxyFilter(configuration.getFilterOrder(), configuration.getRequestMappingConfigurations());
    }
}

