/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.sun;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.gcc.GccCompatibleCCompiler;
import com.github.maven_nar.cpptasks.sun.ForteCCLinker;
import java.io.File;
import java.util.Vector;

public final class ForteF77Compiler
extends GccCompatibleCCompiler {
    private static final ForteF77Compiler instance = new ForteF77Compiler("f77");
    private String identifier;
    private File[] includePath;

    public static ForteF77Compiler getInstance() {
        return instance;
    }

    private ForteF77Compiler(String command) {
        super(command, "-V", false, null, false, null);
    }

    @Override
    public void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-c");
        if (debug) {
            args.addElement("-g");
        }
        if (optimization != null && optimization.isSpeed()) {
            args.addElement("-xO2");
        }
        if (multithreaded) {
            args.addElement("-mt");
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("-KPIC");
        }
    }

    @Override
    public void addWarningSwitch(Vector<String> args, int level) {
        switch (level) {
            case 0: {
                args.addElement("-w");
                break;
            }
            case 1: 
            case 2: {
                args.addElement("+w");
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                args.addElement("+w2");
            }
        }
    }

    @Override
    public File[] getEnvironmentIncludePath() {
        if (this.includePath == null) {
            File compilerIncludeDir;
            File f77Loc = CUtil.getExecutableLocation("f77");
            if (f77Loc != null && (compilerIncludeDir = new File(new File(f77Loc, "../include").getAbsolutePath())).exists()) {
                this.includePath = new File[2];
                this.includePath[0] = compilerIncludeDir;
            }
            if (this.includePath == null) {
                this.includePath = new File[1];
            }
            this.includePath[this.includePath.length - 1] = new File("/usr/include");
        }
        return this.includePath;
    }

    @Override
    public Linker getLinker(LinkType linkType) {
        return ForteCCLinker.getInstance().getLinker(linkType);
    }

    @Override
    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }
}

