/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.gcc;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.CommandLineCCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public abstract class GccCompatibleCCompiler
extends CommandLineCCompiler {
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cpp", ".cxx", ".c++", ".i", ".f", ".for", ".f90"};

    protected GccCompatibleCCompiler(String command, String identifierArg, boolean libtool, GccCompatibleCCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(command, identifierArg, sourceExtensions, headerExtensions, libtool ? ".fo" : ".o", libtool, libtoolCompiler, newEnvironment, env);
    }

    protected GccCompatibleCCompiler(String command, String identifierArg, String[] sourceExtensions, String[] headerExtensions, boolean libtool, GccCompatibleCCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(command, identifierArg, sourceExtensions, headerExtensions, libtool ? ".fo" : ".o", libtool, libtoolCompiler, newEnvironment, env);
    }

    @Override
    public void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-c");
        if (debug) {
            args.addElement("-g");
        } else if (optimization != null) {
            if (optimization.isSize()) {
                args.addElement("-Os");
            } else if (optimization.isSpeed()) {
                if ("full".equals(optimization.getValue())) {
                    args.addElement("-O2");
                } else if ("speed".equals(optimization.getValue())) {
                    args.addElement("-O1");
                } else {
                    args.addElement("-O3");
                }
            }
        }
        if (this.getIdentifier().indexOf("mingw") >= 0) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("-mconsole");
            }
            if (linkType.isSubsystemGUI()) {
                args.addElement("-mwindows");
            }
        }
        if (!exceptions) {
            args.addElement("-fno-exceptions");
        }
    }

    public void addIncludePath(String path, Vector<String> cmd) {
        cmd.addElement("-I" + path);
    }

    @Override
    public void addWarningSwitch(Vector<String> args, int level) {
        switch (level) {
            case 0: {
                args.addElement("-w");
                break;
            }
            case 5: {
                args.addElement("-Werror");
            }
            case 4: {
                args.addElement("-W");
            }
            case 3: {
                args.addElement("-Wall");
            }
        }
    }

    @Override
    public void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-D");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ":");
    }

    @Override
    public String getIncludeDirSwitch(String includeDir) {
        return this.getIncludeDirSwitch(includeDir, false);
    }

    @Override
    public String getIncludeDirSwitch(String includeDir, boolean isSystem) {
        if (isSystem) {
            return "-isystem" + includeDir;
        }
        return "-I" + includeDir;
    }

    @Override
    public void getUndefineSwitch(StringBuffer buffer, String define) {
        buffer.append("-U");
        buffer.append(define);
    }
}

