/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractNarMojo;
import com.github.maven_nar.Library;
import com.github.maven_nar.NarProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="nar-system-generate", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresProject=true)
public class NarSystemMojo
extends AbstractNarMojo {
    private BuildContext buildContext;

    @Override
    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        String extraMethods;
        String loadLibraryString;
        String importString;
        String packageName = null;
        String narSystemName = null;
        File narSystemDirectory = null;
        boolean jniFound = false;
        for (Library library : this.getLibraries()) {
            if (!library.getType().equals("jni") && !library.getType().equals("shared")) continue;
            packageName = library.getNarSystemPackage();
            narSystemName = library.getNarSystemName();
            narSystemDirectory = new File(this.getTargetDirectory(), library.getNarSystemDirectory());
            jniFound = true;
        }
        if (!jniFound || packageName == null) {
            if (!jniFound) {
                this.getLog().debug((CharSequence)"NAR: not building a shared or JNI library, so not generating NarSystem class.");
            } else {
                this.getLog().warn((CharSequence)"NAR: no system package specified; unable to generate NarSystem class.");
            }
            return;
        }
        narSystemDirectory.mkdirs();
        this.getMavenProject().addCompileSourceRoot(narSystemDirectory.getPath());
        File fullDir = new File(narSystemDirectory, packageName.replace('.', '/'));
        fullDir.mkdirs();
        File narSystem = new File(fullDir, narSystemName + ".java");
        this.getLog().info((CharSequence)("Generating " + narSystem));
        String output = this.getOutput(true);
        if (this.hasNativeLibLoaderAsDependency()) {
            this.getLog().info((CharSequence)"Using 'native-lib-loader'");
            importString = "import java.io.File;\nimport java.net.URL;\nimport org.scijava.nativelib.DefaultJniExtractor;\nimport org.scijava.nativelib.JniExtractor;\n";
            loadLibraryString = "final String fileName = \"" + output + "\";\n" + "        final String mapped = System.mapLibraryName(fileName);\n" + "        final String[] aols = getAOLs();\n" + "        final ClassLoader loader = NarSystem.class.getClassLoader();\n" + "        final File unpacked = getUnpackedLibPath(loader, aols, fileName, mapped);\n" + "        if (unpacked != null) {\n" + "            System.load(unpacked.getPath());\n" + "        } else try {\n" + "            final String libPath = getLibPath(loader, aols, mapped);\n" + "            final JniExtractor extractor = new DefaultJniExtractor(NarSystem.class, System.getProperty(\"java.io.tmpdir\"));\n" + "            final File extracted = extractor.extractJni(libPath, fileName);\n" + "            System.load(extracted.getPath());\n" + "        } catch (final Exception e) {\n" + "            e.printStackTrace();\n" + "            throw e instanceof RuntimeException ?\n" + "                (RuntimeException) e : new RuntimeException(e);\n" + "        }";
            extraMethods = this.generateExtraMethods();
        } else {
            this.getLog().info((CharSequence)"Not using 'native-lib-loader' because it is not a dependency)");
            importString = null;
            loadLibraryString = "System.loadLibrary(\"" + output + "\");";
            extraMethods = null;
        }
        try {
            FileOutputStream fos = new FileOutputStream(narSystem);
            PrintWriter p = new PrintWriter(fos);
            p.println("// DO NOT EDIT: Generated by NarSystemGenerate.");
            p.println("package " + packageName + ";");
            p.println("");
            if (importString != null) {
                p.println(importString);
            }
            p.println("/**");
            p.println(" * Generated class to load the correct version of the jni library");
            p.println(" *");
            p.println(" * @author nar-maven-plugin");
            p.println(" */");
            p.println("public final class NarSystem");
            p.println("{");
            p.println("");
            p.println("    private NarSystem() ");
            p.println("    {");
            p.println("    }");
            p.println("");
            p.println("   /**");
            p.println("    * Load jni library: " + output);
            p.println("    *");
            p.println("    * @author nar-maven-plugin");
            p.println("    */");
            p.println("    public static void loadLibrary()");
            p.println("    {");
            p.println("        " + loadLibraryString);
            p.println("    }");
            p.println("");
            p.println("    public static int runUnitTests() {");
            p.println("\t       return new NarSystem().runUnitTestsNative();");
            p.println("    }");
            p.println("");
            p.println("    public native int runUnitTestsNative();");
            if (extraMethods != null) {
                p.println(extraMethods);
            }
            p.println("}");
            p.close();
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write '" + narSystemName + "'", (Exception)e);
        }
        if (this.buildContext != null) {
            this.buildContext.refresh(narSystem);
        }
    }

    private boolean hasNativeLibLoaderAsDependency() {
        for (MavenProject project = this.getMavenProject(); project != null; project = project.getParent()) {
            List dependencies = project.getDependencies();
            for (Dependency dependency : dependencies) {
                String artifactId = dependency.getArtifactId();
                if (!"native-lib-loader".equals(artifactId)) continue;
                return true;
            }
        }
        return false;
    }

    private String generateExtraMethods() throws MojoFailureException {
        StringBuilder builder = new StringBuilder();
        builder.append("\n    private static String[] getAOLs() {\n");
        builder.append("        final String ao = System.getProperty(\"os.arch\") + \"-\" + System.getProperty(\"os.name\").replaceAll(\" \", \"\");\n");
        LinkedHashMap<String, ArrayList<String>> aoMap = new LinkedHashMap<String, ArrayList<String>>();
        for (String aol : NarProperties.getInstance(this.getMavenProject()).getKnownAOLs()) {
            int dash;
            String ao = aol.substring(0, dash = aol.lastIndexOf(45));
            ArrayList<String> list = (ArrayList<String>)aoMap.get(ao);
            if (list == null) {
                list = new ArrayList<String>();
                aoMap.put(ao, list);
            }
            list.add(aol);
        }
        builder.append("\n        // choose the list of known AOLs for the current platform\n");
        String delimiter = "        ";
        for (Map.Entry entry : aoMap.entrySet()) {
            builder.append(delimiter);
            delimiter = " else ";
            builder.append("if (ao.startsWith(\"").append((String)entry.getKey()).append("\")) {\n");
            builder.append("            return new String[] {\n");
            String delimiter2 = "              ";
            for (String aol : (List)entry.getValue()) {
                builder.append(delimiter2).append("\"").append(aol).append("\"");
                delimiter2 = ", ";
            }
            builder.append("\n            };");
            builder.append("\n        }");
        }
        builder.append(" else {\n");
        builder.append("            throw new RuntimeException(\"Unhandled architecture/OS: \" + ao);\n");
        builder.append("        }\n");
        builder.append("    }\n");
        builder.append("\n");
        builder.append("    private static File getUnpackedLibPath(final ClassLoader loader, final String[] aols, final String fileName, final String mapped) {\n");
        builder.append("        final String classPath = NarSystem.class.getName().replace('.', '/') + \".class\";\n");
        builder.append("        final URL url = loader.getResource(classPath);\n");
        builder.append("        if (url == null || !\"file\".equals(url.getProtocol())) return null;\n");
        builder.append("        final String path = url.getPath();\n");
        builder.append("        final String prefix = path.substring(0, path.length() - classPath.length()) + \"../nar/\" + fileName + \"-\";\n");
        builder.append("        for (final String aol : aols) {\n");
        builder.append("            final File file = new File(prefix + aol + \"-jni/lib/\" + aol + \"/jni/\" + mapped);\n");
        builder.append("            if (file.isFile()) return file;\n");
        builder.append("        }\n");
        builder.append("        return null;\n");
        builder.append("    }\n");
        builder.append("\n");
        builder.append("    private static String getLibPath(final ClassLoader loader, final String[] aols, final String mapped) {\n");
        builder.append("        for (final String aol : aols) {\n");
        builder.append("            final String libPath = \"lib/\" + aol + \"/jni/\";\n");
        builder.append("            if (loader.getResource(libPath + mapped) != null) return libPath;\n");
        builder.append("        }\n");
        builder.append("        throw new RuntimeException(\"Library '\" + mapped + \"' not found!\");\n");
        builder.append("    }\n");
        return builder.toString();
    }
}

