/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.Library;
import com.github.maven_nar.ProcessLibraryCommand;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="nar-process-libraries", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresProject=true)
public class NarProcessLibraries
extends AbstractCompileMojo {
    @Parameter
    private List<ProcessLibraryCommand> commands;
    private Log log = this.getLog();

    protected List getArtifacts() {
        return null;
    }

    @Override
    public void narExecute() throws MojoFailureException, MojoExecutionException {
        this.log.info((CharSequence)"Running process libraries");
        for (Library library : this.getLibraries()) {
            File outFile;
            File outDir;
            this.log.info((CharSequence)("Processing library " + library));
            String type = library.getType();
            if (type.equalsIgnoreCase("executable")) {
                outDir = this.getLayout().getBinDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), this.getAOL().toString());
                outFile = new File(outDir, this.getOutput(false));
            } else {
                outDir = this.getLayout().getLibDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), this.getAOL().toString(), type);
                outFile = new File(outDir, this.getOutput(true));
            }
            for (ProcessLibraryCommand processLibraryCommand : this.commands == null ? new ArrayList() : this.commands) {
                if (!processLibraryCommand.getType().equalsIgnoreCase(type)) continue;
                this.runCommand(processLibraryCommand, outFile);
            }
        }
    }

    private void runCommand(ProcessLibraryCommand command, File outputFile) throws MojoFailureException, MojoExecutionException {
        ProcessBuilder p = new ProcessBuilder(command.getCommandList());
        p.command().add(outputFile.toString());
        p.redirectErrorStream(true);
        this.log.info((CharSequence)("Running command \"" + p.command() + "\""));
        try {
            Process process = p.start();
            BufferedInputStream bis = new BufferedInputStream(process.getInputStream());
            byte[] buffer = new byte[1024];
            int endOfStream = 0;
            do {
                this.log.debug((CharSequence)new String(buffer, 0, (endOfStream = bis.read(buffer)) == -1 ? 0 : endOfStream));
            } while (endOfStream != -1);
            if (process.waitFor() != 0) {
                throw new MojoFailureException("Process exited abnormally");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoFailureException("Failed to run the command \"" + p.command() + "\"", (Throwable)e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new MojoFailureException("Failed to run the command \"" + p.command() + "\"", (Throwable)e);
        }
    }
}

