/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractDependencyMojo;
import com.github.maven_nar.AttachedNarArtifact;
import com.github.maven_nar.NarArtifact;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="nar-assembly", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class NarAssemblyMojo
extends AbstractDependencyMojo {
    protected List getArtifacts() {
        return this.getMavenProject().getCompileArtifacts();
    }

    @Override
    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        List<NarArtifact> narArtifacts = this.getNarArtifacts();
        List<AttachedNarArtifact> dependencies = this.getAllAttachedNarArtifacts(narArtifacts);
        this.downloadAttachedNars(dependencies);
        this.unpackAttachedNars(dependencies);
        for (Artifact artifact : dependencies) {
            this.getLog().debug((CharSequence)("Assemble from " + artifact));
            artifact.isSnapshot();
            File srcDir = this.getLayout().getNarUnpackDirectory(this.getUnpackDirectory(), this.getNarManager().getNarFile(artifact));
            File dstDir = this.getTargetDirectory();
            try {
                FileUtils.mkdir((String)dstDir.getPath());
                this.getLog().debug((CharSequence)("SrcDir: " + srcDir));
                if (!srcDir.exists()) continue;
                FileUtils.copyDirectoryStructureIfModified((File)srcDir, (File)dstDir);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to copy directory for dependency " + artifact + " from " + srcDir + " to " + dstDir, (Exception)ioe);
            }
        }
    }
}

