/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.legacycompatibilitysslsocketfactory;

import com.github.marschall.legacycompatibilitysslsocketfactory.LegacyCompatibilitySSLSocket;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Objects;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class LegacyCompatibilitySSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;

    public LegacyCompatibilitySSLSocketFactory() {
        this((SSLSocketFactory)SSLSocketFactory.getDefault());
    }

    public LegacyCompatibilitySSLSocketFactory(SSLSocketFactory delegate) {
        Objects.requireNonNull(delegate, "delegate");
        this.delegate = delegate;
    }

    public static SocketFactory getDefault() {
        return DefaultInstanceHolder.DEFAULT_INSTANCE;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return new LegacyCompatibilitySSLSocket((SSLSocket)this.delegate.createSocket());
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return new LegacyCompatibilitySSLSocket((SSLSocket)this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return new LegacyCompatibilitySSLSocket((SSLSocket)this.delegate.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return new LegacyCompatibilitySSLSocket((SSLSocket)this.delegate.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
        return new LegacyCompatibilitySSLSocket((SSLSocket)this.delegate.createSocket(s, consumed, autoClose));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return new LegacyCompatibilitySSLSocket((SSLSocket)this.delegate.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return new LegacyCompatibilitySSLSocket((SSLSocket)this.delegate.createSocket(address, port, localAddress, localPort));
    }

    private static final class DefaultInstanceHolder {
        static final SocketFactory DEFAULT_INSTANCE = new LegacyCompatibilitySSLSocketFactory();

        private DefaultInstanceHolder() {
        }
    }
}

