/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.legacycompatibilitysslsocketfactory;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Objects;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;

final class CertificateAdapter
extends javax.security.cert.X509Certificate {
    private final X509Certificate delegate;

    CertificateAdapter(X509Certificate delegate) {
        Objects.requireNonNull(delegate, "delegate");
        this.delegate = delegate;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, javax.security.cert.CertificateNotYetValidException {
        try {
            this.delegate.checkValidity();
        }
        catch (java.security.cert.CertificateExpiredException e) {
            CertificateExpiredException deprecatedException = new CertificateExpiredException(e.getMessage());
            deprecatedException.initCause(e);
            throw deprecatedException;
        }
        catch (CertificateNotYetValidException e) {
            javax.security.cert.CertificateNotYetValidException deprecatedException = new javax.security.cert.CertificateNotYetValidException(e.getMessage());
            deprecatedException.initCause(e);
            throw deprecatedException;
        }
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, javax.security.cert.CertificateNotYetValidException {
        try {
            this.delegate.checkValidity(date);
        }
        catch (java.security.cert.CertificateExpiredException e) {
            CertificateExpiredException deprecatedException = new CertificateExpiredException(e.getMessage());
            deprecatedException.initCause(e);
            throw deprecatedException;
        }
        catch (CertificateNotYetValidException e) {
            javax.security.cert.CertificateNotYetValidException deprecatedException = new javax.security.cert.CertificateNotYetValidException(e.getMessage());
            deprecatedException.initCause(e);
            throw deprecatedException;
        }
    }

    @Override
    public int getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.delegate.getSerialNumber();
    }

    @Override
    public Principal getIssuerDN() {
        return this.delegate.getIssuerDN();
    }

    @Override
    public Principal getSubjectDN() {
        return this.delegate.getSubjectDN();
    }

    @Override
    public Date getNotBefore() {
        return this.delegate.getNotBefore();
    }

    @Override
    public Date getNotAfter() {
        return this.delegate.getNotAfter();
    }

    @Override
    public String getSigAlgName() {
        return this.delegate.getSigAlgName();
    }

    @Override
    public String getSigAlgOID() {
        return this.delegate.getSigAlgOID();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.delegate.getSigAlgParams();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.delegate.getEncoded();
        }
        catch (java.security.cert.CertificateEncodingException e) {
            CertificateEncodingException deprecatedException = new CertificateEncodingException(e.getMessage());
            deprecatedException.initCause(e);
            throw deprecatedException;
        }
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.delegate.verify(key);
        }
        catch (java.security.cert.CertificateException e) {
            CertificateException deprecatedException = new CertificateException(e.getMessage());
            deprecatedException.initCause(e);
            throw deprecatedException;
        }
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.delegate.verify(key, sigProvider);
        }
        catch (java.security.cert.CertificateException e) {
            CertificateException deprecatedException = new CertificateException(e.getMessage());
            deprecatedException.initCause(e);
            throw deprecatedException;
        }
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.delegate.getPublicKey();
    }
}

