/*
 * Decompiled with CFR 0.152.
 */
package com.github.mangstadt.vinnie.io;

import com.github.mangstadt.vinnie.SyntaxStyle;
import java.util.HashMap;
import java.util.Map;

public class SyntaxRules {
    private SyntaxStyle defaultSyntaxStyle;
    private final Map<String, Map<String, SyntaxStyle>> syntaxRules = new HashMap<String, Map<String, SyntaxStyle>>();

    public SyntaxRules(SyntaxStyle defaultSyntaxStyle) {
        this.defaultSyntaxStyle = defaultSyntaxStyle;
    }

    public SyntaxStyle getDefaultSyntaxStyle() {
        return this.defaultSyntaxStyle;
    }

    public void setDefaultSyntaxStyle(SyntaxStyle defaultSyntaxStyle) {
        this.defaultSyntaxStyle = defaultSyntaxStyle;
    }

    public boolean hasSyntaxRules(String component) {
        if (component != null) {
            component = component.toUpperCase();
        }
        return this.syntaxRules.containsKey(component);
    }

    public SyntaxStyle getSyntaxStyle(String component, String versionValue) {
        component = component == null ? null : component.toUpperCase();
        Map<String, SyntaxStyle> rules = this.syntaxRules.get(component);
        return rules == null ? null : rules.get(versionValue);
    }

    public void addRule(String component, String version, SyntaxStyle syntaxStyle) {
        Map<String, SyntaxStyle> rules = this.syntaxRules.get(component = component == null ? null : component.toUpperCase());
        if (rules == null) {
            rules = new HashMap<String, SyntaxStyle>();
            this.syntaxRules.put(component, rules);
        }
        rules.put(version, syntaxStyle);
    }

    public static SyntaxRules iCalendar() {
        SyntaxRules rules = new SyntaxRules(SyntaxStyle.OLD);
        String component = "VCALENDAR";
        rules.addRule(component, "1.0", SyntaxStyle.OLD);
        rules.addRule(component, "2.0", SyntaxStyle.NEW);
        return rules;
    }

    public static SyntaxRules vcard() {
        SyntaxRules rules = new SyntaxRules(SyntaxStyle.OLD);
        String component = "VCARD";
        rules.addRule(component, "2.1", SyntaxStyle.OLD);
        rules.addRule(component, "3.0", SyntaxStyle.NEW);
        rules.addRule(component, "4.0", SyntaxStyle.NEW);
        return rules;
    }
}

