/*
 * Decompiled with CFR 0.152.
 */
package com.github.mangstadt.vinnie;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VObjectParameters
implements Iterable<Map.Entry<String, List<String>>> {
    private final Map<String, List<String>> multimap;

    public VObjectParameters() {
        this.multimap = new LinkedHashMap<String, List<String>>();
    }

    public VObjectParameters(Map<String, List<String>> map) {
        this.multimap = map;
    }

    public VObjectParameters(VObjectParameters original) {
        this();
        for (Map.Entry<String, List<String>> entry : original) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            this.multimap.put(name, new ArrayList<String>(values));
        }
    }

    public List<String> get(String key) {
        key = this.sanitizeKey(key);
        return this._get(key);
    }

    private List<String> _get(String key) {
        return this.multimap.get(key);
    }

    public void put(String key, String value) {
        key = this.sanitizeKey(key);
        this._put(key, value);
    }

    private void _put(String key, String value) {
        List<String> list = this._get(key);
        if (list == null) {
            list = new ArrayList<String>();
            this.multimap.put(key, list);
        }
        list.add(value);
    }

    public void putAll(String key, String ... values) {
        if (values.length == 0) {
            return;
        }
        key = this.sanitizeKey(key);
        this._putAll(key, values);
    }

    private void _putAll(String key, String ... values) {
        List<String> list = this._get(key);
        if (list == null) {
            list = new ArrayList<String>();
            this.multimap.put(key, list);
        }
        list.addAll(Arrays.asList(values));
    }

    public List<String> replace(String key, String value) {
        key = this.sanitizeKey(key);
        List<String> replaced = this._removeAll(key);
        this._put(key, value);
        return replaced;
    }

    public List<String> replaceAll(String key, String ... values) {
        key = this.sanitizeKey(key);
        List<String> replaced = this._removeAll(key);
        if (values.length > 0) {
            this._putAll(key, values);
        }
        return replaced;
    }

    public boolean remove(String key, String value) {
        List<String> values = this.get(key);
        return values == null ? false : values.remove(value);
    }

    public List<String> removeAll(String key) {
        key = this.sanitizeKey(key);
        return this._removeAll(key);
    }

    private List<String> _removeAll(String key) {
        return this.multimap.remove(key);
    }

    public void clear() {
        this.multimap.clear();
    }

    public String first(String key) {
        List<String> values = this.get(key);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    public boolean isQuotedPrintable() {
        for (String key : new String[]{"ENCODING", null}) {
            List<String> values = this._get(key);
            if (values == null) continue;
            for (String value : values) {
                if (!"QUOTED-PRINTABLE".equalsIgnoreCase(value)) continue;
                return true;
            }
        }
        return false;
    }

    public Charset getCharset() throws IllegalCharsetNameException, UnsupportedCharsetException {
        String charsetStr = this.first("CHARSET");
        return charsetStr == null ? null : Charset.forName(charsetStr);
    }

    public Map<String, List<String>> getMap() {
        return this.multimap;
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return this.multimap.entrySet().iterator();
    }

    private String sanitizeKey(String key) {
        return key == null ? null : key.toUpperCase();
    }

    public int hashCode() {
        return this.multimap.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VObjectParameters other = (VObjectParameters)obj;
        return this.multimap.equals(other.multimap);
    }

    public String toString() {
        return this.multimap.toString();
    }
}

