/*
 * Decompiled with CFR 0.152.
 */
package com.github.lolo.ltsv;

import com.github.lolo.ltsv.LineIterator;
import com.github.lolo.ltsv.ParseLtsvException;
import com.github.lolo.ltsv.ParseMode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class LtsvParser {
    private int entryDelimiter = 9;
    private int kvDelimiter = 58;
    private int escapeChar = 92;
    private int quoteChar = 34;
    private int lineEnding = 10;
    private boolean strict = true;
    private boolean skipNullValues = false;
    private boolean trimKeys = false;
    private boolean trimValues = false;
    private LinkedList<ParseMode> mode = new LinkedList();

    private LtsvParser() {
    }

    public static Builder builder() {
        LtsvParser ltsvParser = new LtsvParser();
        ltsvParser.getClass();
        return ltsvParser.new Builder();
    }

    public Iterator<Map<String, String>> parse(String data, Charset charset) {
        return this.parse(new ByteArrayInputStream(data.getBytes(charset)));
    }

    public Iterator<Map<String, String>> parse(InputStream data) {
        return LineIterator.newIterator(data, this::parseLine);
    }

    private void putEntry(Map<String, String> result, ByteArrayOutputStream key, ByteArrayOutputStream value, int lineNum, int position) {
        if (key.size() > 0) {
            if (value.size() == 0) {
                if (!this.skipNullValues) {
                    if (this.trimKeys) {
                        result.put(new String(key.toByteArray(), StandardCharsets.UTF_8).trim(), null);
                    } else {
                        result.put(new String(key.toByteArray(), StandardCharsets.UTF_8), null);
                    }
                }
            } else if (this.trimKeys && this.trimValues) {
                result.put(new String(key.toByteArray(), StandardCharsets.UTF_8).trim(), new String(value.toByteArray(), StandardCharsets.UTF_8).trim());
            } else if (this.trimKeys && !this.trimValues) {
                result.put(new String(key.toByteArray(), StandardCharsets.UTF_8).trim(), new String(value.toByteArray(), StandardCharsets.UTF_8));
            } else if (!this.trimKeys && this.trimValues) {
                result.put(new String(key.toByteArray(), StandardCharsets.UTF_8), new String(value.toByteArray(), StandardCharsets.UTF_8).trim());
            } else {
                result.put(new String(key.toByteArray(), StandardCharsets.UTF_8), new String(value.toByteArray(), StandardCharsets.UTF_8));
            }
        } else if (value.size() > 0) {
            if (this.strict) {
                throw new ParseLtsvException(String.format("Empty key detected at line [%d] position [%d]", lineNum, position));
            }
            if (this.trimValues) {
                result.put(null, new String(value.toByteArray(), StandardCharsets.UTF_8).trim());
            } else {
                result.put(null, new String(value.toByteArray(), StandardCharsets.UTF_8));
            }
        }
        key.reset();
        value.reset();
    }

    private Map<String, String> parseLine(InputStream data, int lineNum) throws IOException {
        this.mode.push(ParseMode.KEY);
        ByteArrayOutputStream key = new ByteArrayOutputStream(1024);
        ByteArrayOutputStream value = new ByteArrayOutputStream(1024);
        HashMap<String, String> result = new HashMap<String, String>();
        int position = 0;
        while (data.available() > 0 && this.mode.peek() != ParseMode.EOL) {
            int c = data.read();
            ++position;
            switch (this.mode.peek()) {
                case KEY: {
                    if (c == this.lineEnding) {
                        this.mode.pop();
                        this.mode.push(ParseMode.EOL);
                        break;
                    }
                    if (c == this.entryDelimiter) {
                        if (this.strict) {
                            throw new ParseLtsvException(String.format("Key without a value at line [%d] position [%d]", lineNum, position));
                        }
                        key.write(c);
                        break;
                    }
                    if (c == this.quoteChar) {
                        if (this.strict) {
                            throw new ParseLtsvException(String.format("Unexpected quote token [%c] at line [%d] position [%d]", c, lineNum, position));
                        }
                        key.write(c);
                        break;
                    }
                    if (c == this.escapeChar) {
                        if (this.strict) {
                            throw new ParseLtsvException(String.format("Unexpected escape token [%c] at line [%d] position [%d]", c, lineNum, position));
                        }
                        this.mode.push(ParseMode.ESCAPED);
                        break;
                    }
                    if (c == this.kvDelimiter) {
                        if (key.size() == 0 && this.strict) {
                            throw new ParseLtsvException(String.format("Empty key detected at line [%d] position [%d]", lineNum, position));
                        }
                        this.mode.pop();
                        this.mode.push(ParseMode.VALUE);
                        break;
                    }
                    key.write(c);
                    break;
                }
                case VALUE: {
                    if (c == this.lineEnding) {
                        this.mode.pop();
                        this.mode.push(ParseMode.EOL);
                        break;
                    }
                    if (c == this.quoteChar && value.size() == 0) {
                        this.mode.push(ParseMode.QUOTED);
                        break;
                    }
                    if (c == this.escapeChar) {
                        this.mode.push(ParseMode.ESCAPED);
                        break;
                    }
                    if (c == this.entryDelimiter) {
                        this.mode.push(ParseMode.ENTRY_DELIMITER);
                        break;
                    }
                    value.write(c);
                    break;
                }
                case ESCAPED: {
                    this.mode.pop();
                    if (this.mode.peek() == ParseMode.KEY) {
                        key.write(c);
                        break;
                    }
                    value.write(c);
                    break;
                }
                case QUOTED: {
                    if (c == this.escapeChar) {
                        this.mode.push(ParseMode.ESCAPED);
                        break;
                    }
                    if (c == this.quoteChar) {
                        this.mode.pop();
                        if (!this.strict) break;
                        this.mode.pop();
                        this.mode.push(ParseMode.VALUE);
                        this.mode.push(ParseMode.ENTRY_DELIMITER);
                        break;
                    }
                    if (this.mode.peekLast() == ParseMode.KEY) {
                        key.write(c);
                        break;
                    }
                    value.write(c);
                    break;
                }
                case ENTRY_DELIMITER: {
                    if (c == this.lineEnding) {
                        this.mode.pop();
                        this.mode.push(ParseMode.EOL);
                        break;
                    }
                    if (c == this.entryDelimiter) break;
                    if (c == this.escapeChar) {
                        if (this.strict) {
                            throw new ParseLtsvException(String.format("Unexpected quote token [%c] at line [%d] position [%d]", c, lineNum, position));
                        }
                        this.putEntry(result, key, value, lineNum, position);
                        this.mode.pop();
                        this.mode.pop();
                        this.mode.push(ParseMode.KEY);
                        break;
                    }
                    if (c == this.quoteChar) {
                        if (this.strict) {
                            throw new ParseLtsvException(String.format("Unexpected escape token [%c] at line [%d] position [%d]", c, lineNum, position));
                        }
                        this.putEntry(result, key, value, lineNum, position);
                        this.mode.pop();
                        this.mode.pop();
                        this.mode.push(ParseMode.KEY);
                        this.mode.push(ParseMode.QUOTED);
                        break;
                    }
                    if (c == this.kvDelimiter) {
                        this.putEntry(result, key, value, lineNum, position);
                        this.mode.pop();
                        this.mode.pop();
                        this.mode.push(ParseMode.VALUE);
                        break;
                    }
                    this.mode.pop();
                    this.putEntry(result, key, value, lineNum, position);
                    if (this.mode.peek() == ParseMode.KEY) {
                        value.write(c);
                    } else {
                        key.write(c);
                    }
                    this.mode.pop();
                    this.mode.push(ParseMode.KEY);
                }
            }
        }
        this.putEntry(result, key, value, lineNum, position);
        this.mode.clear();
        return result;
    }

    public class Builder {
        private Builder() {
        }

        public Builder strict() {
            LtsvParser.this.strict = true;
            return this;
        }

        public Builder lenient() {
            LtsvParser.this.strict = false;
            return this;
        }

        public Builder withEntryDelimiter(char delim) {
            LtsvParser.this.entryDelimiter = delim;
            return this;
        }

        public Builder withKvDelimiter(char delim) {
            LtsvParser.this.kvDelimiter = delim;
            return this;
        }

        public Builder withEscapeChar(char escape) {
            LtsvParser.this.escapeChar = escape;
            return this;
        }

        public Builder withQuoteChar(char quote) {
            LtsvParser.this.quoteChar = quote;
            return this;
        }

        public Builder withLineEnding(char eol) {
            LtsvParser.this.lineEnding = eol;
            return this;
        }

        public Builder skipNullValues() {
            LtsvParser.this.skipNullValues = true;
            return this;
        }

        public Builder trimKeys() {
            LtsvParser.this.trimKeys = true;
            return this;
        }

        public Builder trimValues() {
            LtsvParser.this.trimValues = true;
            return this;
        }

        public LtsvParser build() {
            return LtsvParser.this;
        }
    }
}

