/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.spring;

import com.github.kongchen.swagger.docgen.util.SpringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SpringResource {
    private Class<?> controllerClass;
    private List<Method> methods;
    private String controllerMapping;
    private String resourceName;
    private String resourceKey;
    private String description;

    public SpringResource(Class<?> clazz, String resourceName, String resourceKey, String description) {
        this.controllerClass = clazz;
        this.resourceName = resourceName;
        this.resourceKey = resourceKey;
        this.description = description;
        this.methods = new ArrayList<Method>();
        String[] controllerRequestMappingValues = SpringUtils.getControllerResquestMapping(this.controllerClass);
        this.controllerMapping = StringUtils.removeEnd((String)controllerRequestMappingValues[0], (String)"/");
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public void setControllerClass(Class<?> controllerClass) {
        this.controllerClass = controllerClass;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public void setMethods(List<Method> methods) {
        this.methods = methods;
    }

    public void addMethod(Method m) {
        this.methods.add(m);
    }

    public String getControllerMapping() {
        return this.controllerMapping;
    }

    public void setControllerMapping(String controllerMapping) {
        this.controllerMapping = controllerMapping;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResource(String resource) {
        this.resourceName = resource;
    }

    public String getResourcePath() {
        return "/" + this.resourceName;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

