/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kongchen.swagger.docgen.GenerateException;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.jackson.ModelResolver;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class ModelModifier
extends ModelResolver {
    private Map<JavaType, JavaType> modelSubtitutes = new HashMap<JavaType, JavaType>();
    private List<String> apiModelPropertyAccessExclusions = new ArrayList<String>();
    private static Logger LOGGER = LoggerFactory.getLogger(ModelModifier.class);

    public ModelModifier(ObjectMapper mapper) {
        super(mapper);
    }

    public void addModelSubstitute(String fromClass, String toClass) throws GenerateException {
        JavaType type = null;
        JavaType toType = null;
        try {
            type = this._mapper.constructType(Class.forName(fromClass));
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(String.format("Problem with loading class: %s. Mapping from: %s to: %s will be ignored.", fromClass, fromClass, toClass));
        }
        try {
            toType = this._mapper.constructType(Class.forName(toClass));
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(String.format("Problem with loading class: %s. Mapping from: %s to: %s will be ignored.", toClass, fromClass, toClass));
        }
        if (type != null && toType != null) {
            this.modelSubtitutes.put(type, toType);
        }
    }

    public List<String> getApiModelPropertyAccessExclusions() {
        return this.apiModelPropertyAccessExclusions;
    }

    public void setApiModelPropertyAccessExclusions(List<String> apiModelPropertyAccessExclusions) {
        this.apiModelPropertyAccessExclusions = apiModelPropertyAccessExclusions;
    }

    public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
        JavaType javaType = this.toJavaType(type);
        if (this.modelSubtitutes.containsKey(javaType)) {
            return super.resolveProperty(this.modelSubtitutes.get(javaType), context, annotations, chain);
        }
        if (chain.hasNext()) {
            return chain.next().resolveProperty(type, context, annotations, chain);
        }
        return super.resolveProperty(type, context, annotations, chain);
    }

    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType javaType = this.toJavaType(type);
        if (this.modelSubtitutes.containsKey(javaType)) {
            return super.resolve(this.modelSubtitutes.get(javaType), context, chain);
        }
        return super.resolve(type, context, chain);
    }

    public Model resolve(JavaType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        ApiModelProperty apiModelPropertyAnnotation;
        Model model = super.resolve(type, context, chain);
        if (this.apiModelPropertyAccessExclusions == null || this.apiModelPropertyAccessExclusions.isEmpty()) {
            return model;
        }
        Class cls = type.getRawClass();
        for (Method method : cls.getDeclaredMethods()) {
            apiModelPropertyAnnotation = (ApiModelProperty)AnnotationUtils.findAnnotation((Method)method, ApiModelProperty.class);
            this.processProperty(apiModelPropertyAnnotation, model);
        }
        for (AccessibleObject accessibleObject : FieldUtils.getAllFields((Class)cls)) {
            apiModelPropertyAnnotation = (ApiModelProperty)AnnotationUtils.getAnnotation((AnnotatedElement)accessibleObject, ApiModelProperty.class);
            this.processProperty(apiModelPropertyAnnotation, model);
        }
        return model;
    }

    private void processProperty(ApiModelProperty apiModelPropertyAnnotation, Model model) {
        if (apiModelPropertyAnnotation == null) {
            return;
        }
        String apiModelPropertyAccess = apiModelPropertyAnnotation.access();
        String apiModelPropertyName = apiModelPropertyAnnotation.name();
        if (apiModelPropertyAccess.isEmpty() || apiModelPropertyName.isEmpty()) {
            return;
        }
        if (this.apiModelPropertyAccessExclusions.contains(apiModelPropertyAccess)) {
            model.getProperties().remove(apiModelPropertyName);
        }
    }

    private JavaType toJavaType(Type type) {
        JavaType typeToFind = type instanceof JavaType ? (JavaType)type : this._mapper.constructType(type);
        return typeToFind;
    }
}

