/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.mojo;

import com.github.klieber.phantomjs.exec.ExecutionException;
import com.github.klieber.phantomjs.exec.PhantomJsExecutor;
import com.github.klieber.phantomjs.exec.PhantomJsProcessBuilder;
import com.github.klieber.phantomjs.mojo.AbstractPhantomJsMojo;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="exec", defaultPhase=LifecyclePhase.TEST)
public class ExecPhantomJsMojo
extends AbstractPhantomJsMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecPhantomJsMojo.class);
    private static final String EXECUTION_FAILURE = "Failed to execute PhantomJS command";
    private static final String ABNORMAL_EXIT_CODE = "PhantomJS execution did not exit normally (code = %d)";
    @Parameter(property="phantomjs.workingDirectory", defaultValue="${project.basedir}")
    private String workingDirectory;
    @Parameter(property="phantomjs.commandLineOptions")
    private String commandLineOptions;
    @Parameter(property="phantomjs.script")
    private String script;
    @Parameter(property="phantomjs.args")
    private List<String> arguments;
    @Parameter(property="phantomjs.configFile")
    private File configFile;
    @Parameter(property="phantomjs.failOnNonZeroExitCode", defaultValue="true")
    private boolean failOnNonZeroExitCode;
    private PhantomJsExecutor executor;

    public ExecPhantomJsMojo() {
        this(new PhantomJsExecutor());
    }

    public ExecPhantomJsMojo(PhantomJsExecutor executor) {
        this.executor = executor;
    }

    @Override
    public void run() throws MojoFailureException {
        LOGGER.info("Executing phantomjs command");
        String binary = this.getPhantomJsBinary();
        PhantomJsProcessBuilder processBuilder = new PhantomJsProcessBuilder(binary).configFile(this.configFile).workingDirectory(this.workingDirectory).commandLineOptions(this.commandLineOptions).script(this.script).arguments(this.arguments);
        try {
            int code = this.executor.execute(processBuilder);
            if (this.failOnNonZeroExitCode && code != 0) {
                throw new MojoFailureException(String.format(ABNORMAL_EXIT_CODE, code));
            }
        }
        catch (ExecutionException e) {
            throw new MojoFailureException(EXECUTION_FAILURE, (Throwable)e);
        }
    }
}

