/*
 * Decompiled with CFR 0.152.
 */
package redis.protocol;

import akka.util.ByteString;

public final class ParseNumber$ {
    public static final ParseNumber$ MODULE$ = new ParseNumber$();

    public int parseInt(ByteString byteString) {
        if (byteString == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int len = byteString.length();
        int limit = -Integer.MAX_VALUE;
        if (len > 0) {
            byte firstChar = byteString.apply(0);
            if (firstChar < 48) {
                if (firstChar == 45) {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != 43) {
                    throw new NumberFormatException(byteString.toString());
                }
                if (len == 1) {
                    throw new NumberFormatException(byteString.toString());
                }
                ++i;
            }
            int multmin = limit / 10;
            while (i < len) {
                int digit = byteString.apply(i) - 48;
                ++i;
                if (digit < 0 || digit > 9) {
                    throw new NumberFormatException(byteString.toString());
                }
                if (result < multmin) {
                    throw new NumberFormatException(byteString.toString());
                }
                if ((result *= 10) < limit + digit) {
                    throw new NumberFormatException(byteString.toString());
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException(byteString.toString());
        }
        return negative ? result : -result;
    }

    public long parseLong(ByteString byteString) {
        if (byteString == null) {
            throw new NumberFormatException("null");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = byteString.length();
        long limit = -Long.MAX_VALUE;
        if (len > 0) {
            byte firstChar = byteString.apply(0);
            if (firstChar < 48) {
                if (firstChar == 45) {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != 43) {
                    throw new NumberFormatException(byteString.toString());
                }
                if (len == 1) {
                    throw new NumberFormatException(byteString.toString());
                }
                ++i;
            }
            long multmin = limit / 10L;
            while (i < len) {
                int digit = byteString.apply(i) - 48;
                ++i;
                if (digit < 0 || digit > 9) {
                    throw new NumberFormatException(byteString.toString());
                }
                if (result < multmin) {
                    throw new NumberFormatException(byteString.toString());
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw new NumberFormatException(byteString.toString());
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException(byteString.toString());
        }
        return negative ? result : -result;
    }

    private ParseNumber$() {
    }
}

