/*
 * Decompiled with CFR 0.152.
 */
package redis;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.dispatch.MessageDispatcher;
import java.io.Serializable;
import java.net.InetSocketAddress;
import redis.BufferedRequest;
import redis.ByteStringDeserializer;
import redis.ByteStringSerializer;
import redis.ByteStringSerializer$;
import redis.Cursor;
import redis.Operation;
import redis.Redis$;
import redis.RedisCommand;
import redis.RedisCommands;
import redis.RedisConnection;
import redis.RedisDispatcher;
import redis.RedisReplyDeserializer;
import redis.RedisServer;
import redis.actors.RedisClientActor$;
import redis.api.Aggregate;
import redis.api.BitOperator;
import redis.api.Limit;
import redis.api.LimitOffsetCount;
import redis.api.ListPivot;
import redis.api.Order;
import redis.api.ShutdownModifier;
import redis.api.ZaddOption;
import redis.api.clusters.ClusterNodeInfo;
import redis.api.clusters.ClusterSlot;
import redis.api.geo.DistUnits;
import redis.api.geo.GeoOptions;
import redis.api.scripting.RedisScript;
import redis.commands.Clusters;
import redis.commands.Connection;
import redis.commands.Geo;
import redis.commands.Hashes;
import redis.commands.HyperLogLog;
import redis.commands.Keys;
import redis.commands.Lists;
import redis.commands.Publish;
import redis.commands.Scripting;
import redis.commands.Server;
import redis.commands.Sets;
import redis.commands.SortedSets;
import redis.commands.Strings;
import redis.protocol.RedisReply;
import redis.protocol.Status;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Queue;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055g!\u0002\f\u0018\u0003\u0003Q\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011)\u0002!\u0011!Q\u0001\n-BQa\f\u0001\u0005\u0002ABQ\u0001\u000e\u0001\u0007\u0002UBqA\u0011\u0001C\u0002\u001b\u00051\tC\u0004P\u0001\t\u0007I1\u0001)\t\r]\u0003\u0001\u0015!\u0003R\u0011\u001dA\u0006A1A\u0005\neCaA\u001c\u0001!\u0002\u0013Q\u0006\"B8\u0001\t\u0003\u0001\bbBA\u0013\u0001\u0019E\u0011q\u0005\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u0007Bq!a\u0012\u0001\t\u0003\tI\u0005C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBAN\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003;\u0003A\u0011AAP\u0011%\ti\u000bAI\u0001\n\u0003\ty\u000bC\u0004\u0002F\u0002!\t!a2\u0003'I+G-[:DY&,g\u000e\u001e)p_2d\u0015n[3\u000b\u0003a\tQA]3eSN\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\faa]=ti\u0016l\u0007CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0015\t7\r^8s\u0015\u00059\u0013\u0001B1lW\u0006L!!\u000b\u0013\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\u0010e\u0016$\u0017n\u001d#jgB\fGo\u00195feB\u0011A&L\u0007\u0002/%\u0011af\u0006\u0002\u0010%\u0016$\u0017n\u001d#jgB\fGo\u00195fe\u00061A(\u001b8jiz\"2!\r\u001a4!\ta\u0003\u0001C\u0003\"\u0007\u0001\u0007!\u0005C\u0003+\u0007\u0001\u00071&\u0001\fsK\u0012L7oU3sm\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8t+\u00051\u0004\u0003B\u001c;y}j\u0011\u0001\u000f\u0006\u0003su\t!bY8mY\u0016\u001cG/[8o\u0013\tY\u0004HA\u0002NCB\u0004\"\u0001L\u001f\n\u0005y:\"a\u0003*fI&\u001c8+\u001a:wKJ\u0004\"\u0001\f!\n\u0005\u0005;\"a\u0004*fI&\u001c8i\u001c8oK\u000e$\u0018n\u001c8\u0002\t9\fW.Z\u000b\u0002\tB\u0011Q\t\u0014\b\u0003\r*\u0003\"aR\u000f\u000e\u0003!S!!S\r\u0002\rq\u0012xn\u001c;?\u0013\tYU$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&\u001e\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001R!\t\u0011V+D\u0001T\u0015\t!f%\u0001\u0005eSN\u0004\u0018\r^2i\u0013\t16KA\tNKN\u001c\u0018mZ3ESN\u0004\u0018\r^2iKJ\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0003I\u0011X\rZ5t\u0007>tg.Z2uS>t'+\u001a4\u0016\u0003i\u00032a\u00171c\u001b\u0005a&BA/_\u0003\r\u0019H/\u001c\u0006\u0003?v\t!bY8oGV\u0014(/\u001a8u\u0013\t\tGLA\u0002SK\u001a\u00042a\u00195l\u001d\t!gM\u0004\u0002HK&\ta$\u0003\u0002h;\u00059\u0001/Y2lC\u001e,\u0017BA5k\u0005\r\u0019V-\u001d\u0006\u0003Ov\u0001\"a\t7\n\u00055$#\u0001C!di>\u0014(+\u001a4\u0002'I,G-[:D_:tWm\u0019;j_:\u0014VM\u001a\u0011\u0002\u0013\t\u0014x.\u00193dCN$XCA9z)\r\u0011\u0018Q\u0001\t\u0004G\"\u001c\bc\u0001;vo6\ta,\u0003\u0002w=\n1a)\u001e;ve\u0016\u0004\"\u0001_=\r\u0001\u0011)!P\u0003b\u0001w\n\tA+\u0005\u0002}\u007fB\u0011A$`\u0005\u0003}v\u0011qAT8uQ&tw\rE\u0002\u001d\u0003\u0003I1!a\u0001\u001e\u0005\r\te.\u001f\u0005\b\u0003\u000fQ\u0001\u0019AA\u0005\u00031\u0011X\rZ5t\u0007>lW.\u00198ea\u0011\tY!a\u0005\u0011\r1\ni!!\u0005x\u0013\r\tya\u0006\u0002\r%\u0016$\u0017n]\"p[6\fg\u000e\u001a\t\u0004q\u0006MA\u0001DA\u000b\u0003\u000b\t\t\u0011!A\u0003\u0002\u0005]!aA0%cE\u0019A0!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b\u0018\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA\u0012\u0003;\u0011!BU3eSN\u0014V\r\u001d7z\u0003\u0011\u0019XM\u001c3\u0016\t\u0005%\u0012q\u0006\u000b\u0007\u0003W\t\t$!\u000e\u0011\tQ,\u0018Q\u0006\t\u0004q\u0006=B!\u0002>\f\u0005\u0004Y\bBBA\u001a\u0017\u0001\u00071.A\bsK\u0012L7oQ8o]\u0016\u001cG/[8o\u0011\u001d\t9a\u0003a\u0001\u0003o\u0001D!!\u000f\u0002>A9A&!\u0004\u0002<\u00055\u0002c\u0001=\u0002>\u0011a\u0011qHA\u001b\u0003\u0003\u0005\tQ!\u0001\u0002\u0018\t\u0019q\f\n\u001a\u0002)\u001d,GoQ8o]\u0016\u001cG/[8og\u0006\u001bG/\u001b<f+\u0005\u0011\u0017a\u0005:fI&\u001c8i\u001c8oK\u000e$\u0018n\u001c8Q_>d\u0017!C8o\u0007>tg.Z2u)\u0019\tY%!\u0015\u0002ZA\u0019A$!\u0014\n\u0007\u0005=SD\u0001\u0003V]&$\bB\u0002\r\u000f\u0001\u0004\t\u0019\u0006E\u0002-\u0003+J1!a\u0016\u0018\u00055\u0011V\rZ5t\u0007>lW.\u00198eg\"1\u00111\f\bA\u0002q\naa]3sm\u0016\u0014\u0018aD8o\u0007>tg.Z2u'R\fG/^:\u0015\r\u0005\u0005\u0014QNA8!\u001da\u00121MA4\u0003\u0017J1!!\u001a\u001e\u0005%1UO\\2uS>t\u0017\u0007E\u0002\u001d\u0003SJ1!a\u001b\u001e\u0005\u001d\u0011un\u001c7fC:Da!a\u0017\u0010\u0001\u0004a\u0004bBA9\u001f\u0001\u0007\u00111O\u0001\u0007C\u000e$\u0018N^3\u0011\tm\u0003\u0017qM\u0001\u0013e\u00164'/Z:i\u0007>tg.Z2uS>t7\u000f\u0006\u0002\u0002L\u0005!r-\u001a;D_:tWm\u0019;Pa\u0016\u0014\u0018\r^5p]N$B!! \u0002\u001aB)A$a \u0002\u0004&\u0019\u0011\u0011Q\u000f\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003B2i\u0003\u000b\u0003d!a\"\u0002\u0010\u0006U\u0005c\u0002\u0017\u0002\n\u00065\u00151S\u0005\u0004\u0003\u0017;\"!C(qKJ\fG/[8o!\rA\u0018q\u0012\u0003\u000b\u0003#\u000b\u0012\u0011!A\u0001\u0006\u0003Y(aA0%gA\u0019\u00010!&\u0005\u0015\u0005]\u0015#!A\u0001\u0002\u000b\u00051PA\u0002`IQBa!a\u0017\u0012\u0001\u0004a\u0014\u0001B:u_B\f1#\\1lKJ+G-[:D_:tWm\u0019;j_:$b!!)\u0002(\u0006%\u0006#\u0002\u000f\u0002$rz\u0014bAAS;\t1A+\u001e9mKJBa!a\u0017\u0014\u0001\u0004a\u0004\"CAV'A\u0005\t\u0019AA4\u00035!WMZ1vYR\f5\r^5wK\u0006iR.Y6f%\u0016$\u0017n]\"p]:,7\r^5p]\u0012\"WMZ1vYR$#'\u0006\u0002\u00022*\"\u0011qMAZW\t\t)\f\u0005\u0003\u00028\u0006\u0005WBAA]\u0015\u0011\tY,!0\u0002\u0013Ut7\r[3dW\u0016$'bAA`;\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0017\u0011\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F7bW\u0016\u0014V\rZ5t\u00072LWM\u001c;BGR|'\u000fF\u0003l\u0003\u0013\fY\r\u0003\u0004\u0002\\U\u0001\r\u0001\u0010\u0005\b\u0003c*\u0002\u0019AA:\u0001")
public abstract class RedisClientPoolLike {
    private final ActorSystem system;
    private final RedisDispatcher redisDispatcher;
    private final MessageDispatcher executionContext;
    private final Ref<Seq<ActorRef>> redisConnectionRef;

    public abstract Map<RedisServer, RedisConnection> redisServerConnections();

    public abstract String name();

    public MessageDispatcher executionContext() {
        return this.executionContext;
    }

    private Ref<Seq<ActorRef>> redisConnectionRef() {
        return this.redisConnectionRef;
    }

    public <T> Seq<Future<T>> broadcast(RedisCommand<? extends RedisReply, T> redisCommand) {
        return (Seq)this.redisConnectionPool().map((Function1 & Serializable & scala.Serializable)redisConnection -> this.send((ActorRef)redisConnection, redisCommand), Seq$.MODULE$.canBuildFrom());
    }

    public abstract <T> Future<T> send(ActorRef var1, RedisCommand<? extends RedisReply, T> var2);

    public Seq<ActorRef> getConnectionsActive() {
        return ((TraversableOnce)this.redisServerConnections().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<RedisServer, RedisConnection>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                RedisConnection redisConnection;
                A1 A1 = x1;
                Object object = A1 != null && BoxesRunTime.unboxToBoolean((Object)(redisConnection = (RedisConnection)A1._2()).active().single().get()) ? redisConnection.actor() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<RedisServer, RedisConnection> x1) {
                RedisConnection redisConnection;
                Tuple2<RedisServer, RedisConnection> tuple2 = x1;
                boolean bl = tuple2 != null && BoxesRunTime.unboxToBoolean((Object)(redisConnection = (RedisConnection)tuple2._2()).active().single().get());
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toVector();
    }

    public Seq<ActorRef> redisConnectionPool() {
        return (Seq)this.redisConnectionRef().single().get();
    }

    public void onConnect(RedisCommands redis, RedisServer server) {
        server.password().foreach((Function1 & Serializable & scala.Serializable)x$1 -> redis.auth(x$1, ByteStringSerializer$.MODULE$.String()));
        server.db().foreach((Function1 & Serializable & scala.Serializable)index -> redis.select(BoxesRunTime.unboxToInt((Object)index)));
    }

    public Function1<Object, BoxedUnit> onConnectStatus(RedisServer server, Ref<Object> active) {
        return (Function1 & Serializable & scala.Serializable)status -> {
            RedisClientPoolLike.$anonfun$onConnectStatus$1(this, active, BoxesRunTime.unboxToBoolean((Object)status));
            return BoxedUnit.UNIT;
        };
    }

    public void refreshConnections() {
        Seq<ActorRef> actives = this.getConnectionsActive();
        this.redisConnectionRef().single().set(actives);
    }

    public Function0<Seq<Operation<?, ?>>> getConnectOperations(RedisServer server) {
        return (Function0 & Serializable & scala.Serializable)() -> {
            RedisClientPoolLike self = this;
            BufferedRequest redis = new BufferedRequest(null, self){
                private final ExecutionContext executionContext;
                private final Builder<Operation<?, ?>, Queue<Operation<?, ?>>> operations;

                public <K> Future<Object> geoAdd(String key, double lat, double lng, String loc) {
                    return Geo.geoAdd$(this, key, lat, lng, loc);
                }

                public <K> Future<Seq<String>> geoRadius(String key, double lat, double lng, double radius, DistUnits.Measurement dim) {
                    return Geo.geoRadius$(this, key, lat, lng, radius, dim);
                }

                public <K> DistUnits.Measurement geoRadius$default$5() {
                    return Geo.geoRadius$default$5$(this);
                }

                public <K> Future<Seq<String>> geoRadiusByMember(String key, String member, int dist, DistUnits.Measurement dim) {
                    return Geo.geoRadiusByMember$(this, key, member, dist, dim);
                }

                public <K> DistUnits.Measurement geoRadiusByMember$default$4() {
                    return Geo.geoRadiusByMember$default$4$(this);
                }

                public <K> Future<Seq<String>> geoRadiusByMemberWithOpt(String key, String member, int dist, DistUnits.Measurement dim, GeoOptions.WithOption opt, int count) {
                    return Geo.geoRadiusByMemberWithOpt$(this, key, member, dist, dim, opt, count);
                }

                public <K> DistUnits.Measurement geoRadiusByMemberWithOpt$default$4() {
                    return Geo.geoRadiusByMemberWithOpt$default$4$(this);
                }

                public <K> GeoOptions.WithOption geoRadiusByMemberWithOpt$default$5() {
                    return Geo.geoRadiusByMemberWithOpt$default$5$(this);
                }

                public <K> int geoRadiusByMemberWithOpt$default$6() {
                    return Geo.geoRadiusByMemberWithOpt$default$6$(this);
                }

                public <K> Future<Object> geoDist(String key, String member1, String member2, DistUnits.Measurement unit) {
                    return Geo.geoDist$(this, key, member1, member2, unit);
                }

                public <K> DistUnits.Measurement geoDist$default$4() {
                    return Geo.geoDist$default$4$(this);
                }

                public <K> Future<Seq<String>> geoHash(String key, Seq<String> members) {
                    return Geo.geoHash$(this, key, members);
                }

                public <K> Future<Seq<String>> geoPos(String key, Seq<String> members) {
                    return Geo.geoPos$(this, key, members);
                }

                public Future<Seq<ClusterSlot>> clusterSlots() {
                    return Clusters.clusterSlots$(this);
                }

                public Future<scala.collection.immutable.Map<String, String>> clusterInfo() {
                    return Clusters.clusterInfo$(this);
                }

                public Future<ClusterNodeInfo[]> clusterNodes() {
                    return Clusters.clusterNodes$(this);
                }

                public <V> Future<Object> pfadd(String key, Seq<V> values, ByteStringSerializer<V> evidence$1) {
                    return HyperLogLog.pfadd$(this, key, values, evidence$1);
                }

                public Future<Object> pfcount(Seq<String> keys) {
                    return HyperLogLog.pfcount$(this, keys);
                }

                public Future<Object> pfmerge(String destKey, Seq<String> sourceKeys) {
                    return HyperLogLog.pfmerge$(this, destKey, sourceKeys);
                }

                public Future<String> bgrewriteaof() {
                    return Server.bgrewriteaof$(this);
                }

                public Future<String> bgsave() {
                    return Server.bgsave$(this);
                }

                public Future<Object> clientKill(String ip, int port) {
                    return Server.clientKill$(this, ip, port);
                }

                public Future<Seq<scala.collection.immutable.Map<String, String>>> clientList() {
                    return Server.clientList$(this);
                }

                public Future<Option<String>> clientGetname() {
                    return Server.clientGetname$(this);
                }

                public Future<Object> clientSetname(String connectionName) {
                    return Server.clientSetname$(this, connectionName);
                }

                public Future<scala.collection.immutable.Map<String, String>> configGet(String parameter) {
                    return Server.configGet$(this, parameter);
                }

                public Future<Object> configSet(String parameter, String value) {
                    return Server.configSet$(this, parameter, value);
                }

                public Future<Object> configResetstat() {
                    return Server.configResetstat$(this);
                }

                public Future<Object> dbsize() {
                    return Server.dbsize$(this);
                }

                public Future<String> debugObject(String key) {
                    return Server.debugObject$(this, key);
                }

                public Future<String> debugSegfault() {
                    return Server.debugSegfault$(this);
                }

                public Future<Object> flushall() {
                    return Server.flushall$(this);
                }

                public Future<Object> flushdb() {
                    return Server.flushdb$(this);
                }

                public Future<String> info() {
                    return Server.info$(this);
                }

                public Future<String> info(String section) {
                    return Server.info$(this, section);
                }

                public Future<Object> lastsave() {
                    return Server.lastsave$(this);
                }

                public Future<Object> save() {
                    return Server.save$(this);
                }

                public Future<Object> shutdown() {
                    return Server.shutdown$(this);
                }

                public Future<Object> shutdown(ShutdownModifier modifier) {
                    return Server.shutdown$(this, modifier);
                }

                public Future<Object> slaveof(String host, int port) {
                    return Server.slaveof$(this, host, port);
                }

                public Future<Object> slaveofNoOne() {
                    return Server.slaveofNoOne$(this);
                }

                public Future<Tuple2<Object, Object>> time() {
                    return Server.time$(this);
                }

                public <V> Future<Status> auth(V value, ByteStringSerializer<V> evidence$1) {
                    return Connection.auth$(this, value, evidence$1);
                }

                public <V, R> Future<Option<R>> echo(V value, ByteStringSerializer<V> evidence$2, ByteStringDeserializer<R> evidence$3) {
                    return Connection.echo$(this, value, evidence$2, evidence$3);
                }

                public Future<String> ping() {
                    return Connection.ping$(this);
                }

                public Future<Object> quit() {
                    return Connection.quit$(this);
                }

                public Future<Object> select(int index) {
                    return Connection.select$(this, index);
                }

                public <R> Future<R> evalshaOrEval(RedisScript redisScript, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$1) {
                    return Scripting.evalshaOrEval$(this, redisScript, keys, args, evidence$1);
                }

                public <R> Seq<String> evalshaOrEval$default$2() {
                    return Scripting.evalshaOrEval$default$2$(this);
                }

                public <R> Seq<String> evalshaOrEval$default$3() {
                    return Scripting.evalshaOrEval$default$3$(this);
                }

                public <R> Future<R> eval(String script, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$2) {
                    return Scripting.eval$(this, script, keys, args, evidence$2);
                }

                public <R> Seq<String> eval$default$2() {
                    return Scripting.eval$default$2$(this);
                }

                public <R> Seq<String> eval$default$3() {
                    return Scripting.eval$default$3$(this);
                }

                public <R> Future<R> evalsha(String sha1, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$3) {
                    return Scripting.evalsha$(this, sha1, keys, args, evidence$3);
                }

                public <R> Seq<String> evalsha$default$2() {
                    return Scripting.evalsha$default$2$(this);
                }

                public <R> Seq<String> evalsha$default$3() {
                    return Scripting.evalsha$default$3$(this);
                }

                public Future<Object> scriptFlush() {
                    return Scripting.scriptFlush$(this);
                }

                public Future<Object> scriptKill() {
                    return Scripting.scriptKill$(this);
                }

                public Future<String> scriptLoad(String script) {
                    return Scripting.scriptLoad$(this, script);
                }

                public Future<Seq<Object>> scriptExists(Seq<String> sha1) {
                    return Scripting.scriptExists$(this, sha1);
                }

                public <V> Future<Object> publish(String channel, V value, ByteStringSerializer<V> evidence$1) {
                    return Publish.publish$(this, channel, value, evidence$1);
                }

                public <V> Future<Object> zadd(String key, Seq<Tuple2<Object, V>> scoreMembers, ByteStringSerializer<V> evidence$1) {
                    return SortedSets.zadd$(this, key, scoreMembers, evidence$1);
                }

                public <V> Future<Object> zaddWithOptions(String key, Seq<ZaddOption> options, Seq<Tuple2<Object, V>> scoreMembers, ByteStringSerializer<V> evidence$2) {
                    return SortedSets.zaddWithOptions$(this, key, options, scoreMembers, evidence$2);
                }

                public Future<Object> zcard(String key) {
                    return SortedSets.zcard$(this, key);
                }

                public Future<Object> zcount(String key, Limit min, Limit max) {
                    return SortedSets.zcount$(this, key, min, max);
                }

                public Limit zcount$default$2() {
                    return SortedSets.zcount$default$2$(this);
                }

                public Limit zcount$default$3() {
                    return SortedSets.zcount$default$3$(this);
                }

                public <V> Future<Object> zincrby(String key, double increment, V member, ByteStringSerializer<V> evidence$3) {
                    return SortedSets.zincrby$(this, key, increment, member, evidence$3);
                }

                public Future<Object> zinterstore(String destination, String key, Seq<String> keys, Aggregate aggregate) {
                    return SortedSets.zinterstore$(this, destination, key, keys, aggregate);
                }

                public Aggregate zinterstore$default$4() {
                    return SortedSets.zinterstore$default$4$(this);
                }

                public Future<Object> zinterstoreWeighted(String destination, scala.collection.immutable.Map<String, Object> keys, Aggregate aggregate) {
                    return SortedSets.zinterstoreWeighted$(this, destination, keys, aggregate);
                }

                public Aggregate zinterstoreWeighted$default$3() {
                    return SortedSets.zinterstoreWeighted$default$3$(this);
                }

                public <R> Future<Seq<R>> zrange(String key, long start, long stop, ByteStringDeserializer<R> evidence$4) {
                    return SortedSets.zrange$(this, key, start, stop, evidence$4);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrangeWithscores(String key, long start, long stop, ByteStringDeserializer<R> evidence$5) {
                    return SortedSets.zrangeWithscores$(this, key, start, stop, evidence$5);
                }

                public <R> Future<Seq<R>> zrangebyscore(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$6) {
                    return SortedSets.zrangebyscore$(this, key, min, max, limit, evidence$6);
                }

                public <R> Option<Tuple2<Object, Object>> zrangebyscore$default$4() {
                    return SortedSets.zrangebyscore$default$4$(this);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrangebyscoreWithscores(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$7) {
                    return SortedSets.zrangebyscoreWithscores$(this, key, min, max, limit, evidence$7);
                }

                public <R> Option<Tuple2<Object, Object>> zrangebyscoreWithscores$default$4() {
                    return SortedSets.zrangebyscoreWithscores$default$4$(this);
                }

                public <V> Future<Option<Object>> zrank(String key, V member, ByteStringSerializer<V> evidence$8) {
                    return SortedSets.zrank$(this, key, member, evidence$8);
                }

                public <V> Future<Object> zrem(String key, Seq<V> members, ByteStringSerializer<V> evidence$9) {
                    return SortedSets.zrem$(this, key, members, evidence$9);
                }

                public Future<Object> zremrangebylex(String key, String min, String max) {
                    return SortedSets.zremrangebylex$(this, key, min, max);
                }

                public Future<Object> zremrangebyrank(String key, long start, long stop) {
                    return SortedSets.zremrangebyrank$(this, key, start, stop);
                }

                public Future<Object> zremrangebyscore(String key, Limit min, Limit max) {
                    return SortedSets.zremrangebyscore$(this, key, min, max);
                }

                public <R> Future<Seq<R>> zrevrange(String key, long start, long stop, ByteStringDeserializer<R> evidence$10) {
                    return SortedSets.zrevrange$(this, key, start, stop, evidence$10);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrevrangeWithscores(String key, long start, long stop, ByteStringDeserializer<R> evidence$11) {
                    return SortedSets.zrevrangeWithscores$(this, key, start, stop, evidence$11);
                }

                public <R> Future<Seq<R>> zrevrangebyscore(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$12) {
                    return SortedSets.zrevrangebyscore$(this, key, min, max, limit, evidence$12);
                }

                public <R> Option<Tuple2<Object, Object>> zrevrangebyscore$default$4() {
                    return SortedSets.zrevrangebyscore$default$4$(this);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrevrangebyscoreWithscores(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$13) {
                    return SortedSets.zrevrangebyscoreWithscores$(this, key, min, max, limit, evidence$13);
                }

                public <R> Option<Tuple2<Object, Object>> zrevrangebyscoreWithscores$default$4() {
                    return SortedSets.zrevrangebyscoreWithscores$default$4$(this);
                }

                public <V> Future<Option<Object>> zrevrank(String key, V member, ByteStringSerializer<V> evidence$14) {
                    return SortedSets.zrevrank$(this, key, member, evidence$14);
                }

                public <V> Future<Option<Object>> zscore(String key, V member, ByteStringSerializer<V> evidence$15) {
                    return SortedSets.zscore$(this, key, member, evidence$15);
                }

                public Future<Object> zunionstore(String destination, String key, Seq<String> keys, Aggregate aggregate) {
                    return SortedSets.zunionstore$(this, destination, key, keys, aggregate);
                }

                public Aggregate zunionstore$default$4() {
                    return SortedSets.zunionstore$default$4$(this);
                }

                public Future<Object> zunionstoreWeighted(String destination, scala.collection.immutable.Map<String, Object> keys, Aggregate aggregate) {
                    return SortedSets.zunionstoreWeighted$(this, destination, keys, aggregate);
                }

                public Aggregate zunionstoreWeighted$default$3() {
                    return SortedSets.zunionstoreWeighted$default$3$(this);
                }

                public <R> Future<Seq<R>> zrangebylex(String key, Option<String> min, Option<String> max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$16) {
                    return SortedSets.zrangebylex$(this, key, min, max, limit, evidence$16);
                }

                public <R> Option<Tuple2<Object, Object>> zrangebylex$default$4() {
                    return SortedSets.zrangebylex$default$4$(this);
                }

                public <R> Future<Seq<R>> zrevrangebylex(String key, Option<String> max, Option<String> min, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$17) {
                    return SortedSets.zrevrangebylex$(this, key, max, min, limit, evidence$17);
                }

                public <R> Option<Tuple2<Object, Object>> zrevrangebylex$default$4() {
                    return SortedSets.zrevrangebylex$default$4$(this);
                }

                public <R> Future<Cursor<Seq<Tuple2<Object, R>>>> zscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$18) {
                    return SortedSets.zscan$(this, key, cursor, count, matchGlob, evidence$18);
                }

                public <R> int zscan$default$2() {
                    return SortedSets.zscan$default$2$(this);
                }

                public <R> Option<Object> zscan$default$3() {
                    return SortedSets.zscan$default$3$(this);
                }

                public <R> Option<String> zscan$default$4() {
                    return SortedSets.zscan$default$4$(this);
                }

                public <V> Future<Object> sadd(String key, Seq<V> members, ByteStringSerializer<V> evidence$1) {
                    return Sets.sadd$(this, key, members, evidence$1);
                }

                public Future<Object> scard(String key) {
                    return Sets.scard$(this, key);
                }

                public <R> Future<Seq<R>> sdiff(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$2) {
                    return Sets.sdiff$(this, key, keys, evidence$2);
                }

                public Future<Object> sdiffstore(String destination, String key, Seq<String> keys) {
                    return Sets.sdiffstore$(this, destination, key, keys);
                }

                public <R> Future<Seq<R>> sinter(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$3) {
                    return Sets.sinter$(this, key, keys, evidence$3);
                }

                public Future<Object> sinterstore(String destination, String key, Seq<String> keys) {
                    return Sets.sinterstore$(this, destination, key, keys);
                }

                public <V> Future<Object> sismember(String key, V member, ByteStringSerializer<V> evidence$4) {
                    return Sets.sismember$(this, key, member, evidence$4);
                }

                public <R> Future<Seq<R>> smembers(String key, ByteStringDeserializer<R> evidence$5) {
                    return Sets.smembers$(this, key, evidence$5);
                }

                public <V> Future<Object> smove(String source, String destination, V member, ByteStringSerializer<V> evidence$6) {
                    return Sets.smove$(this, source, destination, member, evidence$6);
                }

                public <R> Future<Option<R>> spop(String key, ByteStringDeserializer<R> evidence$7) {
                    return Sets.spop$(this, key, evidence$7);
                }

                public <R> Future<Option<R>> srandmember(String key, ByteStringDeserializer<R> evidence$8) {
                    return Sets.srandmember$(this, key, evidence$8);
                }

                public <R> Future<Seq<R>> srandmember(String key, long count, ByteStringDeserializer<R> evidence$9) {
                    return Sets.srandmember$(this, key, count, evidence$9);
                }

                public <V> Future<Object> srem(String key, Seq<V> members, ByteStringSerializer<V> evidence$10) {
                    return Sets.srem$(this, key, members, evidence$10);
                }

                public <R> Future<Seq<R>> sunion(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$11) {
                    return Sets.sunion$(this, key, keys, evidence$11);
                }

                public Future<Object> sunionstore(String destination, String key, Seq<String> keys) {
                    return Sets.sunionstore$(this, destination, key, keys);
                }

                public <R> Future<Cursor<Seq<R>>> sscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$12) {
                    return Sets.sscan$(this, key, cursor, count, matchGlob, evidence$12);
                }

                public <R> int sscan$default$2() {
                    return Sets.sscan$default$2$(this);
                }

                public <R> Option<Object> sscan$default$3() {
                    return Sets.sscan$default$3$(this);
                }

                public <R> Option<String> sscan$default$4() {
                    return Sets.sscan$default$4$(this);
                }

                public <R> Future<Option<R>> lindex(String key, long index, ByteStringDeserializer<R> evidence$1) {
                    return Lists.lindex$(this, key, index, evidence$1);
                }

                public <V> Future<Object> linsertAfter(String key, String pivot, V value, ByteStringSerializer<V> evidence$2) {
                    return Lists.linsertAfter$(this, key, pivot, value, evidence$2);
                }

                public <V> Future<Object> linsertBefore(String key, String pivot, V value, ByteStringSerializer<V> evidence$3) {
                    return Lists.linsertBefore$(this, key, pivot, value, evidence$3);
                }

                public <V> Future<Object> linsert(String key, ListPivot beforeAfter, String pivot, V value, ByteStringSerializer<V> evidence$4) {
                    return Lists.linsert$(this, key, beforeAfter, pivot, value, evidence$4);
                }

                public Future<Object> llen(String key) {
                    return Lists.llen$(this, key);
                }

                public <R> Future<Option<R>> lpop(String key, ByteStringDeserializer<R> evidence$5) {
                    return Lists.lpop$(this, key, evidence$5);
                }

                public <V> Future<Object> lpush(String key, Seq<V> values, ByteStringSerializer<V> evidence$6) {
                    return Lists.lpush$(this, key, values, evidence$6);
                }

                public <V> Future<Object> lpushx(String key, V value, ByteStringSerializer<V> evidence$7) {
                    return Lists.lpushx$(this, key, value, evidence$7);
                }

                public <R> Future<Seq<R>> lrange(String key, long start, long stop, ByteStringDeserializer<R> evidence$8) {
                    return Lists.lrange$(this, key, start, stop, evidence$8);
                }

                public <V> Future<Object> lrem(String key, long count, V value, ByteStringSerializer<V> evidence$9) {
                    return Lists.lrem$(this, key, count, value, evidence$9);
                }

                public <V> Future<Object> lset(String key, long index, V value, ByteStringSerializer<V> evidence$10) {
                    return Lists.lset$(this, key, index, value, evidence$10);
                }

                public Future<Object> ltrim(String key, long start, long stop) {
                    return Lists.ltrim$(this, key, start, stop);
                }

                public <R> Future<Option<R>> rpop(String key, ByteStringDeserializer<R> evidence$11) {
                    return Lists.rpop$(this, key, evidence$11);
                }

                public <R> Future<Option<R>> rpoplpush(String source, String destination, ByteStringDeserializer<R> evidence$12) {
                    return Lists.rpoplpush$(this, source, destination, evidence$12);
                }

                public <V> Future<Object> rpush(String key, Seq<V> values, ByteStringSerializer<V> evidence$13) {
                    return Lists.rpush$(this, key, values, evidence$13);
                }

                public <V> Future<Object> rpushx(String key, V value, ByteStringSerializer<V> evidence$14) {
                    return Lists.rpushx$(this, key, value, evidence$14);
                }

                public Future<Object> hdel(String key, Seq<String> fields) {
                    return Hashes.hdel$(this, key, fields);
                }

                public Future<Object> hexists(String key, String field) {
                    return Hashes.hexists$(this, key, field);
                }

                public <R> Future<Option<R>> hget(String key, String field, ByteStringDeserializer<R> evidence$1) {
                    return Hashes.hget$(this, key, field, evidence$1);
                }

                public <R> Future<scala.collection.immutable.Map<String, R>> hgetall(String key, ByteStringDeserializer<R> evidence$2) {
                    return Hashes.hgetall$(this, key, evidence$2);
                }

                public Future<Object> hincrby(String key, String fields, long increment) {
                    return Hashes.hincrby$(this, key, fields, increment);
                }

                public Future<Object> hincrbyfloat(String key, String fields, double increment) {
                    return Hashes.hincrbyfloat$(this, key, fields, increment);
                }

                public Future<Seq<String>> hkeys(String key) {
                    return Hashes.hkeys$(this, key);
                }

                public Future<Object> hlen(String key) {
                    return Hashes.hlen$(this, key);
                }

                public <R> Future<Seq<Option<R>>> hmget(String key, Seq<String> fields, ByteStringDeserializer<R> evidence$3) {
                    return Hashes.hmget$(this, key, fields, evidence$3);
                }

                public <V> Future<Object> hmset(String key, scala.collection.immutable.Map<String, V> keysValues, ByteStringSerializer<V> evidence$4) {
                    return Hashes.hmset$(this, key, keysValues, evidence$4);
                }

                public <V> Future<Object> hset(String key, String field, V value, ByteStringSerializer<V> evidence$5) {
                    return Hashes.hset$(this, key, field, value, evidence$5);
                }

                public <V> Future<Object> hsetnx(String key, String field, V value, ByteStringSerializer<V> evidence$6) {
                    return Hashes.hsetnx$(this, key, field, value, evidence$6);
                }

                public <R> Future<Seq<R>> hvals(String key, ByteStringDeserializer<R> evidence$7) {
                    return Hashes.hvals$(this, key, evidence$7);
                }

                public <R> Future<Cursor<scala.collection.immutable.Map<String, R>>> hscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$8) {
                    return Hashes.hscan$(this, key, cursor, count, matchGlob, evidence$8);
                }

                public <R> int hscan$default$2() {
                    return Hashes.hscan$default$2$(this);
                }

                public <R> Option<Object> hscan$default$3() {
                    return Hashes.hscan$default$3$(this);
                }

                public <R> Option<String> hscan$default$4() {
                    return Hashes.hscan$default$4$(this);
                }

                public <V> Future<Object> append(String key, V value, ByteStringSerializer<V> evidence$1) {
                    return Strings.append$(this, key, value, evidence$1);
                }

                public Future<Object> bitcount(String key) {
                    return Strings.bitcount$(this, key);
                }

                public Future<Object> bitcount(String key, long start, long end) {
                    return Strings.bitcount$(this, key, start, end);
                }

                public Future<Object> bitopAND(String destkey, Seq<String> keys) {
                    return Strings.bitopAND$(this, destkey, keys);
                }

                public Future<Object> bitopOR(String destkey, Seq<String> keys) {
                    return Strings.bitopOR$(this, destkey, keys);
                }

                public Future<Object> bitopXOR(String destkey, Seq<String> keys) {
                    return Strings.bitopXOR$(this, destkey, keys);
                }

                public Future<Object> bitopNOT(String destkey, String key) {
                    return Strings.bitopNOT$(this, destkey, key);
                }

                public Future<Object> bitop(BitOperator operation, String destkey, Seq<String> keys) {
                    return Strings.bitop$(this, operation, destkey, keys);
                }

                public Future<Object> bitpos(String key, long bit, long start, long end) {
                    return Strings.bitpos$(this, key, bit, start, end);
                }

                public long bitpos$default$3() {
                    return Strings.bitpos$default$3$(this);
                }

                public long bitpos$default$4() {
                    return Strings.bitpos$default$4$(this);
                }

                public Future<Object> decr(String key) {
                    return Strings.decr$(this, key);
                }

                public Future<Object> decrby(String key, long decrement) {
                    return Strings.decrby$(this, key, decrement);
                }

                public <R> Future<Option<R>> get(String key, ByteStringDeserializer<R> evidence$2) {
                    return Strings.get$(this, key, evidence$2);
                }

                public Future<Object> getbit(String key, long offset) {
                    return Strings.getbit$(this, key, offset);
                }

                public <R> Future<Option<R>> getrange(String key, long start, long end, ByteStringDeserializer<R> evidence$3) {
                    return Strings.getrange$(this, key, start, end, evidence$3);
                }

                public <V, R> Future<Option<R>> getset(String key, V value, ByteStringSerializer<V> evidence$4, ByteStringDeserializer<R> evidence$5) {
                    return Strings.getset$(this, key, value, evidence$4, evidence$5);
                }

                public Future<Object> incr(String key) {
                    return Strings.incr$(this, key);
                }

                public Future<Object> incrby(String key, long increment) {
                    return Strings.incrby$(this, key, increment);
                }

                public Future<Option<Object>> incrbyfloat(String key, double increment) {
                    return Strings.incrbyfloat$(this, key, increment);
                }

                public <R> Future<Seq<Option<R>>> mget(Seq<String> keys, ByteStringDeserializer<R> evidence$6) {
                    return Strings.mget$(this, keys, evidence$6);
                }

                public <V> Future<Object> mset(scala.collection.immutable.Map<String, V> keysValues, ByteStringSerializer<V> evidence$7) {
                    return Strings.mset$(this, keysValues, evidence$7);
                }

                public <V> Future<Object> msetnx(scala.collection.immutable.Map<String, V> keysValues, ByteStringSerializer<V> evidence$8) {
                    return Strings.msetnx$(this, keysValues, evidence$8);
                }

                public <V> Future<Object> psetex(String key, long milliseconds, V value, ByteStringSerializer<V> evidence$9) {
                    return Strings.psetex$(this, key, milliseconds, value, evidence$9);
                }

                public <V> Future<Object> set(String key, V value, Option<Object> exSeconds, Option<Object> pxMilliseconds, boolean NX, boolean XX, ByteStringSerializer<V> evidence$10) {
                    return Strings.set$(this, key, value, exSeconds, pxMilliseconds, NX, XX, evidence$10);
                }

                public <V> Option<Object> set$default$3() {
                    return Strings.set$default$3$(this);
                }

                public <V> Option<Object> set$default$4() {
                    return Strings.set$default$4$(this);
                }

                public <V> boolean set$default$5() {
                    return Strings.set$default$5$(this);
                }

                public <V> boolean set$default$6() {
                    return Strings.set$default$6$(this);
                }

                public Future<Object> setbit(String key, long offset, boolean value) {
                    return Strings.setbit$(this, key, offset, value);
                }

                public <V> Future<Object> setex(String key, long seconds, V value, ByteStringSerializer<V> evidence$11) {
                    return Strings.setex$(this, key, seconds, value, evidence$11);
                }

                public <V> Future<Object> setnx(String key, V value, ByteStringSerializer<V> evidence$12) {
                    return Strings.setnx$(this, key, value, evidence$12);
                }

                public <V> Future<Object> setrange(String key, long offset, V value, ByteStringSerializer<V> evidence$13) {
                    return Strings.setrange$(this, key, offset, value, evidence$13);
                }

                public Future<Object> strlen(String key) {
                    return Strings.strlen$(this, key);
                }

                public Future<Object> del(Seq<String> keys) {
                    return Keys.del$(this, keys);
                }

                public <R> Future<Option<R>> dump(String key, ByteStringDeserializer<R> evidence$1) {
                    return Keys.dump$(this, key, evidence$1);
                }

                public Future<Object> exists(String key) {
                    return Keys.exists$(this, key);
                }

                public Future<Object> existsMany(Seq<String> keys) {
                    return Keys.existsMany$(this, keys);
                }

                public Future<Object> expire(String key, long seconds) {
                    return Keys.expire$(this, key, seconds);
                }

                public Future<Object> expireat(String key, long seconds) {
                    return Keys.expireat$(this, key, seconds);
                }

                public Future<Seq<String>> keys(String pattern) {
                    return Keys.keys$(this, pattern);
                }

                public Future<Object> migrate(String host, int port, String key, int destinationDB, FiniteDuration timeout) {
                    return Keys.migrate$(this, host, port, key, destinationDB, timeout);
                }

                public Future<Object> move(String key, int db) {
                    return Keys.move$(this, key, db);
                }

                public Future<Option<Object>> objectRefcount(String key) {
                    return Keys.objectRefcount$(this, key);
                }

                public Future<Option<Object>> objectIdletime(String key) {
                    return Keys.objectIdletime$(this, key);
                }

                public Future<Option<String>> objectEncoding(String key) {
                    return Keys.objectEncoding$(this, key);
                }

                public Future<Object> persist(String key) {
                    return Keys.persist$(this, key);
                }

                public Future<Object> pexpire(String key, long milliseconds) {
                    return Keys.pexpire$(this, key, milliseconds);
                }

                public Future<Object> pexpireat(String key, long millisecondsTimestamp) {
                    return Keys.pexpireat$(this, key, millisecondsTimestamp);
                }

                public Future<Object> pttl(String key) {
                    return Keys.pttl$(this, key);
                }

                public <R> Future<Option<R>> randomkey(ByteStringDeserializer<R> evidence$2) {
                    return Keys.randomkey$(this, evidence$2);
                }

                public Future<Object> rename(String key, String newkey) {
                    return Keys.rename$(this, key, newkey);
                }

                public Future<Object> renamenx(String key, String newkey) {
                    return Keys.renamenx$(this, key, newkey);
                }

                public <V> Future<Object> restore(String key, long ttl, V serializedValue, ByteStringSerializer<V> evidence$3) {
                    return Keys.restore$(this, key, ttl, serializedValue, evidence$3);
                }

                public <V> long restore$default$2() {
                    return Keys.restore$default$2$(this);
                }

                public <R> Future<Seq<R>> sort(String key, Option<String> byPattern, Option<LimitOffsetCount> limit, Seq<String> getPatterns, Option<Order> order, boolean alpha, ByteStringDeserializer<R> evidence$4) {
                    return Keys.sort$(this, key, byPattern, limit, getPatterns, order, alpha, evidence$4);
                }

                public <R> Option<String> sort$default$2() {
                    return Keys.sort$default$2$(this);
                }

                public <R> Option<LimitOffsetCount> sort$default$3() {
                    return Keys.sort$default$3$(this);
                }

                public <R> Seq<String> sort$default$4() {
                    return Keys.sort$default$4$(this);
                }

                public <R> Option<Order> sort$default$5() {
                    return Keys.sort$default$5$(this);
                }

                public <R> boolean sort$default$6() {
                    return Keys.sort$default$6$(this);
                }

                public Future<Object> sortStore(String key, Option<String> byPattern, Option<LimitOffsetCount> limit, Seq<String> getPatterns, Option<Order> order, boolean alpha, String store) {
                    return Keys.sortStore$(this, key, byPattern, limit, getPatterns, order, alpha, store);
                }

                public Option<String> sortStore$default$2() {
                    return Keys.sortStore$default$2$(this);
                }

                public Option<LimitOffsetCount> sortStore$default$3() {
                    return Keys.sortStore$default$3$(this);
                }

                public Seq<String> sortStore$default$4() {
                    return Keys.sortStore$default$4$(this);
                }

                public Option<Order> sortStore$default$5() {
                    return Keys.sortStore$default$5$(this);
                }

                public boolean sortStore$default$6() {
                    return Keys.sortStore$default$6$(this);
                }

                public Future<Object> ttl(String key) {
                    return Keys.ttl$(this, key);
                }

                public Future<String> type(String key) {
                    return Keys.type$(this, key);
                }

                public Future<Cursor<Seq<String>>> scan(int cursor, Option<Object> count, Option<String> matchGlob) {
                    return Keys.scan$(this, cursor, count, matchGlob);
                }

                public int scan$default$1() {
                    return Keys.scan$default$1$(this);
                }

                public Option<Object> scan$default$2() {
                    return Keys.scan$default$2$(this);
                }

                public Option<String> scan$default$3() {
                    return Keys.scan$default$3$(this);
                }

                public <T> Future<T> send(RedisCommand<? extends RedisReply, T> redisCommand) {
                    return BufferedRequest.send$(this, redisCommand);
                }

                public Builder<Operation<?, ?>, Queue<Operation<?, ?>>> operations() {
                    return this.operations;
                }

                public void redis$BufferedRequest$_setter_$operations_$eq(Builder<Operation<?, ?>, Queue<Operation<?, ?>>> x$1) {
                    this.operations = x$1;
                }

                public ExecutionContext executionContext() {
                    return this.executionContext;
                }
                {
                    BufferedRequest.$init$(this);
                    Keys.$init$(this);
                    Strings.$init$(this);
                    Hashes.$init$(this);
                    Lists.$init$(this);
                    Sets.$init$(this);
                    SortedSets.$init$(this);
                    Publish.$init$(this);
                    Scripting.$init$(this);
                    Connection.$init$(this);
                    Server.$init$(this);
                    HyperLogLog.$init$(this);
                    Clusters.$init$(this);
                    Geo.$init$(this);
                    this.executionContext = self$1.executionContext();
                }
            };
            this.onConnect((RedisCommands)((Object)redis), server);
            return (Queue)redis.operations().result();
        };
    }

    public void stop() {
        this.redisConnectionPool().foreach((Function1 & Serializable & scala.Serializable)redisConnection -> {
            this.system.stop(redisConnection);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<RedisServer, RedisConnection> makeRedisConnection(RedisServer server, boolean defaultActive) {
        Ref active = Ref$.MODULE$.apply(defaultActive);
        return new Tuple2((Object)server, (Object)new RedisConnection(this.makeRedisClientActor(server, (Ref<Object>)active), (Ref<Object>)active));
    }

    public boolean makeRedisConnection$default$2() {
        return false;
    }

    public ActorRef makeRedisClientActor(RedisServer server, Ref<Object> active) {
        return this.system.actorOf(RedisClientActor$.MODULE$.props(new InetSocketAddress(server.host(), server.port()), this.getConnectOperations(server), this.onConnectStatus(server, active), this.redisDispatcher.name(), RedisClientActor$.MODULE$.props$default$5()).withDispatcher(this.redisDispatcher.name()), new StringBuilder(0).append(this.name()).append('-').append(Redis$.MODULE$.tempName()).toString());
    }

    public static final /* synthetic */ void $anonfun$onConnectStatus$1(RedisClientPoolLike $this, Ref active$1, boolean status) {
        block0: {
            if (!active$1.single().compareAndSet((Object)BoxesRunTime.boxToBoolean((!status ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)status))) break block0;
            $this.refreshConnections();
        }
    }

    public RedisClientPoolLike(ActorSystem system, RedisDispatcher redisDispatcher) {
        this.system = system;
        this.redisDispatcher = redisDispatcher;
        this.executionContext = system.dispatchers().lookup(redisDispatcher.name());
        this.redisConnectionRef = Ref$.MODULE$.apply((Object)Seq$.MODULE$.empty(), (OptManifest)ClassManifestFactory$.MODULE$.classType(Seq.class, (OptManifest)ClassManifestFactory$.MODULE$.classType(ActorRef.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0])));
    }
}

