/*
 * Decompiled with CFR 0.152.
 */
package play.cache.redis;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface AsyncRedisList<Elem> {
    public CompletionStage<AsyncRedisList<Elem>> prepend(Elem var1);

    public CompletionStage<AsyncRedisList<Elem>> append(Elem var1);

    public CompletionStage<Elem> apply(int var1);

    public CompletionStage<Optional<Elem>> get(int var1);

    default public CompletionStage<Elem> head() {
        return this.apply(0);
    }

    default public CompletionStage<Optional<Elem>> headOption() {
        return this.get(0);
    }

    public CompletionStage<Optional<Elem>> headPop();

    default public CompletionStage<Elem> last() {
        return this.apply(-1);
    }

    default public CompletionStage<Optional<Elem>> lastOption() {
        return this.get(-1);
    }

    default public CompletionStage<List<Elem>> toList() {
        return this.view().all();
    }

    public CompletionStage<Optional<Long>> insertBefore(Elem var1, Elem var2);

    public CompletionStage<AsyncRedisList<Elem>> set(int var1, Elem var2);

    public CompletionStage<AsyncRedisList<Elem>> remove(Elem var1);

    public CompletionStage<AsyncRedisList<Elem>> remove(Elem var1, int var2);

    public CompletionStage<AsyncRedisList<Elem>> removeAt(int var1);

    public AsyncRedisListView<Elem> view();

    public AsyncRedisListModification<Elem> modify();

    public static interface AsyncRedisListModification<Elem> {
        public AsyncRedisList<Elem> collection();

        default public CompletionStage<AsyncRedisListModification<Elem>> take(int n) {
            return this.slice(0, n - 1);
        }

        default public CompletionStage<AsyncRedisListModification<Elem>> drop(int n) {
            return this.slice(n, -1);
        }

        public CompletionStage<AsyncRedisListModification<Elem>> clear();

        public CompletionStage<AsyncRedisListModification<Elem>> slice(int var1, int var2);
    }

    public static interface AsyncRedisListView<Elem> {
        default public CompletionStage<List<Elem>> take(int n) {
            return this.slice(0, n - 1);
        }

        default public CompletionStage<List<Elem>> drop(int n) {
            return this.slice(n, -1);
        }

        default public CompletionStage<List<Elem>> all() {
            return this.slice(0, -1);
        }

        public CompletionStage<List<Elem>> slice(int var1, int var2);
    }
}

