/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache.redis.connector;

import akka.actor.ActorSystem;
import javax.inject.Provider;
import play.api.cache.redis.configuration.RedisCluster;
import play.api.cache.redis.configuration.RedisInstance;
import play.api.cache.redis.configuration.RedisSentinel;
import play.api.cache.redis.configuration.RedisStandalone;
import play.api.cache.redis.connector.RedisCommandsCluster;
import play.api.cache.redis.connector.RedisCommandsSentinel;
import play.api.cache.redis.connector.RedisCommandsStandalone;
import play.api.inject.ApplicationLifecycle;
import redis.RedisCommands;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!3QAB\u0004\u0001\u000fEA\u0001b\n\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0006a!A\u0001\b\u0001B\u0001B\u0003-\u0011\bC\u0003?\u0001\u0011\u0005q\b\u0003\u0005G\u0001!\u0015\r\u0011\"\u0001H\u0005U\u0011V\rZ5t\u0007>lW.\u00198egB\u0013xN^5eKJT!\u0001C\u0005\u0002\u0013\r|gN\\3di>\u0014(B\u0001\u0006\f\u0003\u0015\u0011X\rZ5t\u0015\taQ\"A\u0003dC\u000eDWM\u0003\u0002\u000f\u001f\u0005\u0019\u0011\r]5\u000b\u0003A\tA\u0001\u001d7bsN\u0019\u0001A\u0005\u000e\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001\u00027b]\u001eT\u0011aF\u0001\u0005U\u00064\u0018-\u0003\u0002\u001a)\t1qJ\u00196fGR\u00042a\u0007\u0011#\u001b\u0005a\"BA\u000f\u001f\u0003\u0019IgN[3di*\tq$A\u0003kCZ\f\u00070\u0003\u0002\"9\tA\u0001K]8wS\u0012,'\u000f\u0005\u0002$K5\tAEC\u0001\u000b\u0013\t1CEA\u0007SK\u0012L7oQ8n[\u0006tGm]\u0001\tS:\u001cH/\u00198dK\u000e\u0001\u0001C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\n\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011af\u000b\u0002\u000e%\u0016$\u0017n]%ogR\fgnY3\u0002\rML8\u000f^3n!\t\td'D\u00013\u0015\t\u0019D'A\u0003bGR|'OC\u00016\u0003\u0011\t7n[1\n\u0005]\u0012$aC!di>\u00148+_:uK6\f\u0011\u0002\\5gK\u000eL8\r\\3\u0011\u0005ibT\"A\u001e\u000b\u0005ui\u0011BA\u001f<\u0005Q\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8MS\u001a,7-_2mK\u00061A(\u001b8jiz\"\"\u0001Q#\u0015\u0007\u0005\u001bE\t\u0005\u0002C\u00015\tq\u0001C\u00030\t\u0001\u000f\u0001\u0007C\u00039\t\u0001\u000f\u0011\bC\u0003(\t\u0001\u0007\u0011&A\u0002hKR,\u0012A\t")
public class RedisCommandsProvider
implements Provider<RedisCommands> {
    private RedisCommands get;
    private final RedisInstance instance;
    private final ActorSystem system;
    private final ApplicationLifecycle lifecycle;
    private volatile boolean bitmap$0;

    private RedisCommands get$lzycompute() {
        RedisCommandsProvider redisCommandsProvider = this;
        synchronized (redisCommandsProvider) {
            if (!this.bitmap$0) {
                RedisCommands redisCommands;
                RedisInstance redisInstance = this.instance;
                if (redisInstance instanceof RedisCluster) {
                    RedisCluster redisCluster = (RedisCluster)redisInstance;
                    redisCommands = new RedisCommandsCluster(redisCluster, this.system, this.lifecycle).get();
                } else if (redisInstance instanceof RedisStandalone) {
                    RedisStandalone redisStandalone = (RedisStandalone)redisInstance;
                    redisCommands = new RedisCommandsStandalone(redisStandalone, this.system, this.lifecycle).get();
                } else if (redisInstance instanceof RedisSentinel) {
                    RedisSentinel redisSentinel = (RedisSentinel)redisInstance;
                    redisCommands = new RedisCommandsSentinel(redisSentinel, this.system, this.lifecycle).get();
                } else {
                    throw new MatchError((Object)redisInstance);
                }
                this.get = redisCommands;
                this.bitmap$0 = true;
            }
        }
        return this.get;
    }

    public RedisCommands get() {
        return !this.bitmap$0 ? this.get$lzycompute() : this.get;
    }

    public RedisCommandsProvider(RedisInstance instance, ActorSystem system, ApplicationLifecycle lifecycle) {
        this.instance = instance;
        this.system = system;
        this.lifecycle = lifecycle;
    }
}

