/*
 * Decompiled with CFR 0.152.
 */
package play.api.cache.redis.configuration;

import com.typesafe.config.Config;
import java.io.Serializable;
import play.api.ConfigLoader;
import play.api.cache.redis.configuration.RedisConfigLoader$;
import play.api.cache.redis.configuration.RedisConfigLoader$ConfigOption$;
import play.api.cache.redis.configuration.RedisConfigLoader$ConfigPath$;
import play.api.cache.redis.configuration.RedisHost;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class RedisHost$
implements ConfigLoader<RedisHost> {
    public static RedisHost$ MODULE$;
    private final Regex ConnectionString;

    static {
        new RedisHost$();
    }

    public String load$default$2() {
        return ConfigLoader.load$default$2$((ConfigLoader)this);
    }

    public <B> ConfigLoader<B> map(Function1<RedisHost, B> f) {
        return ConfigLoader.map$((ConfigLoader)this, f);
    }

    private Regex ConnectionString() {
        return this.ConnectionString;
    }

    public RedisHost load(Config config, String path) {
        return this.apply(config.getString(RedisConfigLoader$ConfigPath$.MODULE$.$div$extension(RedisConfigLoader$.MODULE$.ConfigPath(path), "host")), config.getInt(RedisConfigLoader$ConfigPath$.MODULE$.$div$extension(RedisConfigLoader$.MODULE$.ConfigPath(path), "port")), RedisConfigLoader$ConfigOption$.MODULE$.getOption$extension(RedisConfigLoader$.MODULE$.ConfigOption(config), RedisConfigLoader$ConfigPath$.MODULE$.$div$extension(RedisConfigLoader$.MODULE$.ConfigPath(path), "database"), (Function1 & Serializable & scala.Serializable)x$5 -> (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$5.getInt(x$1))), RedisConfigLoader$ConfigOption$.MODULE$.getOption$extension(RedisConfigLoader$.MODULE$.ConfigOption(config), RedisConfigLoader$ConfigPath$.MODULE$.$div$extension(RedisConfigLoader$.MODULE$.ConfigPath(path), "password"), (Function1 & Serializable & scala.Serializable)x$6 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$6.getString(x$1)));
    }

    public RedisHost fromConnectionString(String connectionString) {
        Option option = this.ConnectionString().findFirstMatchIn((CharSequence)connectionString);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(103).append("Unexpected format of the connection string: '").append(connectionString).append("'. Expected format is 'redis://[user:password@]host:port'.").toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Regex.Match matcher = (Regex.Match)some.value();
        RedisHost redisHost = new RedisHost(matcher){
            private final String host;
            private final int port;
            private final None$ database;
            private final Option<String> password;

            public boolean equals(Object obj) {
                return RedisHost.equals$(this, obj);
            }

            public boolean equalsAsHost(Object obj) {
                return RedisHost.equalsAsHost$(this, obj);
            }

            public String toString() {
                return RedisHost.toString$(this);
            }

            public String host() {
                return this.host;
            }

            public int port() {
                return this.port;
            }

            public None$ database() {
                return this.database;
            }

            public Option<String> password() {
                return this.password;
            }
            {
                RedisHost.$init$(this);
                this.host = matcher$1.group("host");
                this.port = new StringOps(Predef$.MODULE$.augmentString(matcher$1.group("port"))).toInt();
                this.database = None$.MODULE$;
                this.password = Option$.MODULE$.apply((Object)matcher$1.group("password"));
            }
        };
        return redisHost;
    }

    public RedisHost apply(String host, int port, Option<Object> database, Option<String> password) {
        return this.create(host, port, database, password);
    }

    public Option<Object> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    private RedisHost create(String _host, int _port, Option<Object> _database, Option<String> _password) {
        return new RedisHost(_host, _port, _database, _password){
            private final String host;
            private final int port;
            private final Option<Object> database;
            private final Option<String> password;

            public boolean equals(Object obj) {
                return RedisHost.equals$(this, obj);
            }

            public boolean equalsAsHost(Object obj) {
                return RedisHost.equalsAsHost$(this, obj);
            }

            public String toString() {
                return RedisHost.toString$(this);
            }

            public String host() {
                return this.host;
            }

            public int port() {
                return this.port;
            }

            public Option<Object> database() {
                return this.database;
            }

            public Option<String> password() {
                return this.password;
            }
            {
                RedisHost.$init$(this);
                this.host = _host$1;
                this.port = _port$1;
                this.database = _database$1;
                this.password = _password$1;
            }
        };
    }

    public Option<Tuple4<String, Object, Option<Object>, Option<String>>> unapply(RedisHost host) {
        return new Some((Object)new Tuple4((Object)host.host(), (Object)BoxesRunTime.boxToInteger((int)host.port()), host.database(), host.password()));
    }

    private RedisHost$() {
        MODULE$ = this;
        ConfigLoader.$init$((ConfigLoader)this);
        this.ConnectionString = new StringOps(Predef$.MODULE$.augmentString("redis://((?<user>[^:]+):(?<password>[^@]+)@)?(?<host>[^:]+):(?<port>[0-9]+)")).r((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auth", "user", "password", "host", "port"}));
    }
}

