/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.internal.HbsLexer;
import com.github.jknack.handlebars.internal.HbsParser;
import com.github.jknack.handlebars.internal.HbsParserBaseVisitor;
import com.github.jknack.handlebars.internal.antlr.DefaultErrorStrategy;
import com.github.jknack.handlebars.internal.antlr.InputMismatchException;
import com.github.jknack.handlebars.internal.antlr.NoViableAltException;
import com.github.jknack.handlebars.internal.antlr.Parser;
import com.github.jknack.handlebars.internal.antlr.RecognitionException;
import com.github.jknack.handlebars.internal.antlr.Token;
import com.github.jknack.handlebars.internal.antlr.TokenStream;
import com.github.jknack.handlebars.internal.antlr.VocabularyImpl;
import com.github.jknack.handlebars.internal.antlr.misc.IntervalSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

class HbsErrorStrategy
extends DefaultErrorStrategy {
    HbsErrorStrategy() {
    }

    @Override
    public void recover(Parser recognizer, RecognitionException e) {
        throw new HandlebarsException(e);
    }

    @Override
    public Token recoverInline(Parser recognizer) {
        throw new InputMismatchException(recognizer);
    }

    @Override
    public void reportNoViableAlternative(Parser recognizer, NoViableAltException e) {
        HbsParser parser = (HbsParser)recognizer;
        TokenStream tokens = parser.getTokenStream();
        HbsLexer lexer = (HbsLexer)tokens.getTokenSource();
        String msg = (String)new ErrorStrategyVisitor(lexer.start, lexer.end).visit(e.getCtx());
        if (msg != null) {
            recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
        } else {
            super.reportNoViableAlternative(recognizer, e);
        }
    }

    @Override
    public void reportMissingToken(Parser recognizer) {
        if (this.errorRecoveryMode) {
            return;
        }
        Token offendingToken = recognizer.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        String msg = expecting.toString(recognizer.getVocabulary());
        recognizer.notifyErrorListeners(offendingToken, msg, null);
    }

    @Override
    public void reportInputMismatch(Parser recognizer, InputMismatchException e) {
        String[] displayNames = this.displayNames(recognizer);
        String msg = e.getExpectedTokens().toString(VocabularyImpl.fromTokenNames(displayNames));
        recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
    }

    private String[] displayNames(Parser recognizer) {
        HbsParser parser = (HbsParser)recognizer;
        TokenStream tokens = parser.getTokenStream();
        HbsLexer lexer = (HbsLexer)tokens.getTokenSource();
        String[] tokenNames = parser.tokenNames();
        String[] displayName = new String[tokenNames.length];
        for (int i = 0; i < displayName.length; ++i) {
            String[] parts = StringUtils.split((String)tokenNames[i], (String)"_");
            if (parts[0].equals("START")) {
                String suffix = "";
                if (parts.length > 1) {
                    if (parts[1].equals("COMMENT")) {
                        suffix = "!";
                    } else if (parts[1].equals("AMP")) {
                        suffix = "&";
                    } else if (parts[1].equals("T")) {
                        suffix = "{";
                    } else if (parts[1].equals("BLOCK")) {
                        suffix = "#";
                    } else if (parts[1].equals("DELIM")) {
                        suffix = "=";
                    } else if (parts[1].equals("PARTIAL")) {
                        suffix = ">";
                    }
                }
                displayName[i] = lexer.start + suffix;
            } else if (parts[0].equals("END")) {
                String prefix = "";
                if (parts.length > 1) {
                    if (parts[1].equals("BLOCK")) {
                        displayName[i] = lexer.start + "/";
                    } else if (parts[1].equals("DELIM")) {
                        prefix = "=";
                        displayName[i] = prefix + lexer.end;
                    } else if (parts[1].equals("T")) {
                        prefix = "}";
                        displayName[i] = prefix + lexer.end;
                    } else {
                        displayName[i] = prefix + lexer.end;
                    }
                } else {
                    displayName[i] = prefix + lexer.end;
                }
            } else {
                displayName[i] = parts[0].equals("UNLESS") ? "^" : (parts[0].equals("NL") ? "\\n" : (parts[0].equals("WS") ? "space" : (parts[0].equals("DOUBLE") ? "string" : (parts[0].equals("SINGLE") ? "string" : (parts[0].equals("QID") ? "id" : tokenNames[i])))));
            }
            displayName[i] = displayName[i].toLowerCase().replace("'", "");
        }
        return displayName;
    }

    @Override
    public void sync(Parser recognizer) {
    }

    private class ErrorStrategyVisitor
    extends HbsParserBaseVisitor<String> {
        private String startDelimiter;
        private String endDelimiter;

        ErrorStrategyVisitor(String startDelimiter, String endDelimiter) {
            this.startDelimiter = (String)Validate.notEmpty((CharSequence)startDelimiter, (String)"The startDelimiter can't be empty/null.", (Object[])new Object[0]);
            this.endDelimiter = (String)Validate.notEmpty((CharSequence)endDelimiter, (String)"The end delimiter can't be empty/null.", (Object[])new Object[0]);
        }

        @Override
        public String visitVar(HbsParser.VarContext ctx) {
            if (ctx.stop == null) {
                return this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitTvar(HbsParser.TvarContext ctx) {
            if (ctx.stop == null) {
                return "}" + this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitAmpvar(HbsParser.AmpvarContext ctx) {
            if (ctx.stop == null) {
                return this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitBlock(HbsParser.BlockContext ctx) {
            if (ctx.stop == null) {
                return this.startDelimiter + "/";
            }
            return null;
        }

        @Override
        public String visitUnless(HbsParser.UnlessContext ctx) {
            if (ctx.stop == null) {
                return this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitPartial(HbsParser.PartialContext ctx) {
            if (ctx.stop == null) {
                return this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitComment(HbsParser.CommentContext ctx) {
            if (ctx.stop == null) {
                return this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitDelimiters(HbsParser.DelimitersContext ctx) {
            if (ctx.stop == null) {
                return "=" + this.endDelimiter;
            }
            return null;
        }
    }
}

