/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.helper.DefI18nSource;
import com.github.jknack.handlebars.helper.I18nSource;
import com.github.jknack.handlebars.internal.Locales;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum I18nHelper implements Helper<String>
{
    i18n{

        @Override
        public Object apply(String key, Options options) throws IOException {
            Validate.notEmpty((CharSequence)key, (String)"found: '%s', expected 'bundle's key'", (Object[])new Object[]{key});
            Locale locale = Locales.fromString((String)options.hash("locale", this.defaultLocale.toString()));
            String baseName = (String)options.hash("bundle", this.defaultBundle);
            ClassLoader classLoader = (ClassLoader)options.hash("classLoader", this.getClass().getClassLoader());
            I18nSource localSource = this.source == null ? new DefI18nSource(this.charset, baseName, locale, classLoader) : this.source;
            return localSource.message(key, locale, options.params);
        }
    }
    ,
    i18nJs{
        private final Pattern pattern = Pattern.compile("\\{(\\d+)\\}");

        @Override
        public Object apply(String localeName, Options options) throws IOException {
            String[] keys;
            Locale locale = Locales.fromString((String)StringUtils.defaultIfEmpty((CharSequence)localeName, (CharSequence)this.defaultLocale.toString()));
            String baseName = (String)options.hash("bundle", this.defaultBundle);
            ClassLoader classLoader = (ClassLoader)options.hash("classLoader", this.getClass().getClassLoader());
            I18nSource localSource = this.source == null ? new DefI18nSource(this.charset, baseName, locale, classLoader) : this.source;
            StringBuilder buffer = new StringBuilder();
            Boolean wrap = (Boolean)options.hash("wrap", true);
            if (wrap.booleanValue()) {
                buffer.append("<script type='text/javascript'>\n");
            }
            buffer.append("  /* ").append(locale.getDisplayName()).append(" */\n");
            buffer.append("  I18n.translations = I18n.translations || {};\n");
            buffer.append("  I18n.translations['").append(locale.toString()).append("'] = {\n");
            StringBuilder body = new StringBuilder();
            String separator = ",\n";
            for (String key : keys = localSource.keys(baseName, locale)) {
                String message = this.message(localSource.message(key, locale, new Object[0]));
                body.append("    \"").append(key).append("\": ");
                body.append("\"").append(message).append("\"").append(separator);
            }
            if (body.length() > 0) {
                body.setLength(body.length() - separator.length());
                buffer.append((CharSequence)body);
            }
            buffer.append("\n  };\n");
            if (wrap.booleanValue()) {
                buffer.append("</script>\n");
            }
            return new Handlebars.SafeString(buffer);
        }

        private String message(String message) {
            CharSequence escapedMessage = Handlebars.Utils.escapeExpression(message);
            Matcher matcher = this.pattern.matcher(escapedMessage);
            StringBuffer result = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(result, "{{arg" + matcher.group(1) + "}}");
            }
            matcher.appendTail(result);
            return result.toString();
        }
    };

    protected Locale defaultLocale = Locale.getDefault();
    protected String defaultBundle = "messages";
    protected I18nSource source;
    protected Charset charset = StandardCharsets.UTF_8;

    public void setCharset(Charset charset) {
        this.charset = (Charset)Validate.notNull((Object)charset, (String)"Charset required.", (Object[])new Object[0]);
    }

    public void setSource(I18nSource source) {
        this.source = (I18nSource)Validate.notNull((Object)source, (String)"The i18n source is required.", (Object[])new Object[0]);
    }

    public void setDefaultBundle(String bundle) {
        this.defaultBundle = (String)Validate.notEmpty((CharSequence)bundle, (String)"A bundle's name is required.", (Object[])new Object[0]);
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = (Locale)Validate.notNull((Object)locale, (String)"A locale is required.", (Object[])new Object[0]);
    }
}

