/*
 * Decompiled with CFR 0.152.
 */
package com.github.plantuml.maven;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.preproc.Defines;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;

public final class PlantUMLMojo
extends AbstractMojo {
    private final Option option = new Option();
    private FileSet sourceFiles;
    private File outputDirectory;
    private boolean outputInSourceDirectory;
    private String charset;
    private String config;
    private boolean keepTmpFiles;
    private String format;
    private String graphvizDot;
    private boolean verbose;

    protected final void setFormat(String format) {
        if ("xmi".equalsIgnoreCase(format)) {
            this.option.setFileFormat(FileFormat.XMI_STANDARD);
        } else if ("xmi:argo".equalsIgnoreCase(format)) {
            this.option.setFileFormat(FileFormat.XMI_ARGO);
        } else if ("xmi:start".equalsIgnoreCase(format)) {
            this.option.setFileFormat(FileFormat.XMI_STAR);
        } else if ("eps".equalsIgnoreCase(format)) {
            this.option.setFileFormat(FileFormat.EPS);
        } else if ("eps:txt".equalsIgnoreCase(format)) {
            this.option.setFileFormat(FileFormat.EPS_TEXT);
        } else if ("svg".equalsIgnoreCase(format)) {
            this.option.setFileFormat(FileFormat.SVG);
        } else if ("txt".equalsIgnoreCase(format)) {
            this.option.setFileFormat(FileFormat.ATXT);
        } else if ("utxt".equalsIgnoreCase(format)) {
            this.option.setFileFormat(FileFormat.UTXT);
        } else if ("png".equalsIgnoreCase(format)) {
            this.option.setFileFormat(FileFormat.PNG);
        } else if ("pdf".equalsIgnoreCase(format)) {
            this.option.setFileFormat(FileFormat.PDF);
        } else {
            throw new IllegalArgumentException("Unrecognized format <" + format + ">");
        }
    }

    public void execute() throws MojoExecutionException {
        String invalidSourceFilesDirectoryWarnMsg = this.sourceFiles.getDirectory() + " is not a valid path";
        if (null == this.sourceFiles.getDirectory() || this.sourceFiles.getDirectory().isEmpty()) {
            this.getLog().warn((CharSequence)invalidSourceFilesDirectoryWarnMsg);
            return;
        }
        File baseDir = null;
        try {
            baseDir = new File(this.sourceFiles.getDirectory());
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)invalidSourceFilesDirectoryWarnMsg, (Throwable)e);
        }
        if (null == baseDir || !baseDir.exists() || !baseDir.isDirectory()) {
            this.getLog().warn((CharSequence)invalidSourceFilesDirectoryWarnMsg);
            return;
        }
        if (!this.outputInSourceDirectory) {
            if (!this.outputDirectory.exists()) {
                this.outputDirectory.mkdirs();
            }
            if (!this.outputDirectory.isDirectory()) {
                throw new IllegalArgumentException("<" + this.outputDirectory + "> is not a valid directory.");
            }
        }
        try {
            if (!this.outputInSourceDirectory) {
                this.option.setOutputDir(this.outputDirectory);
            }
            if (this.charset != null) {
                this.option.setCharset(this.charset);
            }
            if (this.config != null) {
                this.option.initConfig(this.config);
            }
            if (this.keepTmpFiles) {
                OptionFlags.getInstance().setKeepTmpFiles(this.keepTmpFiles);
            }
            if (this.graphvizDot != null) {
                OptionFlags.getInstance().setDotExecutable(this.graphvizDot);
            }
            if (this.format != null) {
                this.setFormat(this.format);
            }
            if (this.verbose) {
                OptionFlags.getInstance().setVerbose(true);
            }
            List files = FileUtils.getFiles((File)baseDir, (String)this.getCommaSeparatedList(this.sourceFiles.getIncludes()), (String)this.getCommaSeparatedList(this.sourceFiles.getExcludes()));
            for (File file : files) {
                this.getLog().info((CharSequence)("Processing file <" + file + ">"));
                if (this.outputInSourceDirectory) {
                    this.option.setOutputDir(file.getParentFile());
                } else {
                    this.option.setOutputDir(this.outputDirectory.toPath().resolve(baseDir.toPath().relativize(file.toPath().getParent())).toFile());
                }
                SourceFileReader sourceFileReader = new SourceFileReader(new Defines(), file, this.option.getOutputDir(), this.option.getConfig(), this.option.getCharset(), this.option.getFileFormatOption());
                for (GeneratedImage image : sourceFileReader.getGeneratedImages()) {
                    this.getLog().debug((CharSequence)(image + " " + image.getDescription()));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception during plantuml process", e);
        }
    }

    protected String getCommaSeparatedList(List<String> list) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            String object = it.next();
            builder.append(object.toString());
            if (!it.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }
}

