/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.serialization.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jcustenborder.kafka.serialization.jackson.JacksonDeserializerConfig;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonDeserializer<T>
implements Deserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(JacksonDeserializer.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    Class<T> cls;
    private JacksonDeserializerConfig config;

    public JacksonDeserializer() {
    }

    public JacksonDeserializer(Class<T> cls) {
        this();
        this.cls = cls;
    }

    public static Map<String, String> nonDefaultSettings(ObjectMapper objectMapper) {
        return JacksonDeserializerConfig.nonDefaultSettings(objectMapper);
    }

    public void configure(Map<String, ?> settings, boolean isKey) {
        this.config = new JacksonDeserializerConfig(settings);
        this.config.configure(this.objectMapper);
        if (null != this.cls) {
            log.trace("cls is already configured to {}", (Object)this.cls.getName());
        } else {
            this.cls = this.config.outputClass;
        }
    }

    public T deserialize(String topic, byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(bytes, this.cls);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public void close() {
    }
}

