/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SerializationSettings {
    private List<String> relationshipIncludes;
    private List<String> relationshipExcludes;
    private Boolean serializeMeta;
    private Boolean serializeLinks;
    private Boolean serializeId;
    private Boolean serializeLocalId;
    private Boolean serializeJSONAPIObject;

    private SerializationSettings() {
    }

    public boolean isRelationshipIncluded(String relationshipName) {
        return this.relationshipIncludes.contains(relationshipName);
    }

    public boolean isRelationshipExcluded(String relationshipName) {
        return this.relationshipExcludes.contains(relationshipName);
    }

    public boolean hasIncludedRelationships() {
        HashSet<String> includedRelationships = new HashSet<String>(this.relationshipIncludes);
        includedRelationships.removeAll(this.relationshipExcludes);
        return !includedRelationships.isEmpty();
    }

    public Boolean serializeMeta() {
        return this.serializeMeta;
    }

    public Boolean serializeLinks() {
        return this.serializeLinks;
    }

    public Boolean serializeId() {
        return this.serializeId;
    }

    public Boolean serializeLocalId() {
        return this.serializeLocalId;
    }

    public Boolean serializeJSONAPIObject() {
        return this.serializeJSONAPIObject;
    }

    public static class Builder {
        private final List<String> relationshipIncludes = new ArrayList<String>();
        private final List<String> relationshipExcludes = new ArrayList<String>();
        private Boolean serializeMeta;
        private Boolean serializeLinks;
        private Boolean serializeId;
        private Boolean serializeLocalId;
        private Boolean serializeJSONAPIObject;

        public Builder includeRelationship(String relationshipName) {
            this.relationshipIncludes.add(relationshipName);
            return this;
        }

        public Builder excludedRelationships(String relationshipName) {
            this.relationshipExcludes.add(relationshipName);
            return this;
        }

        public Builder serializeMeta(Boolean flag) {
            this.serializeMeta = flag;
            return this;
        }

        public Builder serializeLinks(Boolean flag) {
            this.serializeLinks = flag;
            return this;
        }

        public Builder serializeId(Boolean flag) {
            this.serializeId = flag;
            return this;
        }

        public Builder serializeLocalId(Boolean flag) {
            this.serializeLocalId = flag;
            return this;
        }

        public Builder serializeJSONAPIObject(Boolean flag) {
            this.serializeJSONAPIObject = flag;
            return this;
        }

        public SerializationSettings build() {
            SerializationSettings result = new SerializationSettings();
            result.relationshipIncludes = new ArrayList<String>(this.relationshipIncludes);
            result.relationshipExcludes = new ArrayList<String>(this.relationshipExcludes);
            result.serializeLinks = this.serializeLinks;
            result.serializeMeta = this.serializeMeta;
            result.serializeId = this.serializeId;
            result.serializeJSONAPIObject = this.serializeJSONAPIObject;
            result.serializeLocalId = this.serializeLocalId;
            return result;
        }
    }
}

