/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import java.util.HashSet;
import java.util.Set;

public enum DeserializationFeature {
    REQUIRE_RESOURCE_ID(true),
    REQUIRE_LOCAL_RESOURCE_ID(false),
    ALLOW_UNKNOWN_INCLUSIONS(false),
    ALLOW_UNKNOWN_TYPE_IN_RELATIONSHIP(false);

    private final boolean enabledByDefault;

    private DeserializationFeature(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
    }

    public static Set<DeserializationFeature> getDefaultFeatures() {
        HashSet<DeserializationFeature> result = new HashSet<DeserializationFeature>();
        for (DeserializationFeature deserializationFeature : DeserializationFeature.values()) {
            if (!deserializationFeature.enabledByDefault) continue;
            result.add(deserializationFeature);
        }
        return result;
    }
}

