/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import java.util.HashMap;
import java.util.Map;

public class ResourceCache {
    private ThreadLocal<Map<String, Object>> resourceCache = new ThreadLocal();
    private ThreadLocal<Integer> initDepth = new ThreadLocal();
    private ThreadLocal<Boolean> cacheLocked = new ThreadLocal();

    public void init() {
        if (this.initDepth.get() == null) {
            this.initDepth.set(1);
        } else {
            this.initDepth.set(this.initDepth.get() + 1);
        }
        if (this.resourceCache.get() == null) {
            this.resourceCache.set(new HashMap());
        }
        if (this.cacheLocked.get() == null) {
            this.cacheLocked.set(Boolean.FALSE);
        }
    }

    public void clear() {
        this.verifyState();
        this.initDepth.set(this.initDepth.get() - 1);
        if (this.initDepth.get() == 0) {
            this.resourceCache.set(null);
            this.cacheLocked.set(null);
            this.initDepth.set(null);
        }
    }

    public void cache(Map<String, Object> resources) {
        this.verifyState();
        if (!this.cacheLocked.get().booleanValue()) {
            this.resourceCache.get().putAll(resources);
        }
    }

    public void cache(String identifier, Object resource) {
        this.verifyState();
        if (!this.cacheLocked.get().booleanValue()) {
            this.resourceCache.get().put(identifier, resource);
        }
    }

    public Object get(String identifier) {
        this.verifyState();
        return this.resourceCache.get().get(identifier);
    }

    public boolean contains(String identifier) {
        this.verifyState();
        return this.resourceCache.get().containsKey(identifier);
    }

    public void lock() {
        this.verifyState();
        this.cacheLocked.set(true);
    }

    public void unlock() {
        this.verifyState();
        this.cacheLocked.set(false);
    }

    private void verifyState() {
        if (this.resourceCache.get() == null) {
            throw new IllegalStateException("Cache not initialised, call init() first");
        }
    }
}

