/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.Link;
import com.github.jasminb.jsonapi.Links;
import com.github.jasminb.jsonapi.models.errors.Error;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSONAPIDocument<T> {
    private T data;
    private ObjectMapper deserializer;
    private Iterable<? extends Error> errors;
    private Links links;
    private Map<String, Object> meta;
    private JsonNode responseJSONNode;

    public JSONAPIDocument(T data) {
        this.data = data;
    }

    public JSONAPIDocument(T data, ObjectMapper deserializer) {
        this(data);
        this.deserializer = deserializer;
    }

    public JSONAPIDocument(T data, JsonNode jsonNode, ObjectMapper deserializer) {
        this(data);
        this.deserializer = deserializer;
        this.responseJSONNode = jsonNode;
    }

    public JSONAPIDocument(T data, Links links, Map<String, Object> meta) {
        this(data);
        this.links = links;
        this.meta = meta;
    }

    public JSONAPIDocument(T data, Links links, Map<String, Object> meta, ObjectMapper deserializer) {
        this(data, links, meta);
        this.deserializer = deserializer;
    }

    public JSONAPIDocument() {
    }

    public JSONAPIDocument(Iterable<? extends Error> errors) {
        this.errors = errors;
    }

    public JSONAPIDocument(Error error) {
        this.errors = Arrays.asList(error);
    }

    @NotNull
    public static JSONAPIDocument<?> createErrorDocument(Iterable<? extends Error> errors) {
        JSONAPIDocument result = new JSONAPIDocument();
        result.errors = errors;
        return result;
    }

    @Nullable
    public T get() {
        return this.data;
    }

    @Nullable
    public Map<String, ?> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, ?> meta) {
        this.meta = new HashMap(meta);
    }

    public void addMeta(String key, Object value) {
        if (this.meta == null) {
            this.meta = new HashMap<String, Object>();
        }
        this.meta.put(key, value);
    }

    @Nullable
    public Links getLinks() {
        return this.links;
    }

    public void addLink(String linkName, Link link) {
        if (this.links == null) {
            this.links = new Links(new HashMap<String, Link>());
        }
        this.links.addLink(linkName, link);
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    @Nullable
    public <M> M getMeta(Class<?> metaType) {
        if (this.meta != null && this.deserializer != null) {
            return (M)this.deserializer.convertValue(this.meta, metaType);
        }
        return null;
    }

    @Nullable
    public Iterable<? extends Error> getErrors() {
        return this.errors;
    }

    public JsonNode getResponseJSONNode() {
        return this.responseJSONNode;
    }
}

