/*
 * Decompiled with CFR 0.152.
 */
package smile.util.function;

import smile.util.function.Function;

public interface DifferentiableFunction
extends Function {
    public double g(double var1);

    default public double g2(double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public double root(double x1, double x2, double tol, int maxIter) {
        double dxold;
        double xh;
        double xl;
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        double fl = this.f(x1);
        double fh = this.f(x2);
        if (fl > 0.0 && fh > 0.0 || fl < 0.0 && fh < 0.0) {
            throw new IllegalArgumentException("Root must be bracketed in rtsafe");
        }
        if (fl == 0.0) {
            return x1;
        }
        if (fh == 0.0) {
            return x2;
        }
        if (fl < 0.0) {
            xl = x1;
            xh = x2;
        } else {
            xh = x1;
            xl = x2;
        }
        double rts = 0.5 * (x1 + x2);
        double dx = dxold = Math.abs(x2 - x1);
        double f = this.f(rts);
        double df = this.g(rts);
        for (int iter = 1; iter <= maxIter; ++iter) {
            if (((rts - xh) * df - f) * ((rts - xl) * df - f) > 0.0 || Math.abs(2.0 * f) > Math.abs(dxold * df)) {
                dxold = dx;
                dx = 0.5 * (xh - xl);
                rts = xl + dx;
                if (xl == rts) {
                    logger.info("Newton-Raphson finds the root after {} iterations: {}, error = {}", new Object[]{iter, rts, dx});
                    return rts;
                }
            } else {
                dxold = dx;
                double temp = rts;
                dx = f / df;
                if (temp == (rts -= dx)) {
                    logger.info("Newton-Raphson finds the root after {} iterations: {}, error = {}", new Object[]{iter, rts, dx});
                    return rts;
                }
            }
            if (iter % 10 == 0) {
                logger.info("Newton-Raphson: the root after {} iterations: {}, error = {}", new Object[]{iter, rts, dx});
            }
            if (Math.abs(dx) < tol) {
                logger.info("Newton-Raphson finds the root after {} iterations: {}, error = {}", new Object[]{iter, rts, dx});
                return rts;
            }
            f = this.f(rts);
            df = this.g(rts);
            if (f < 0.0) {
                xl = rts;
                continue;
            }
            xh = rts;
        }
        logger.error("Newton-Raphson exceeded the maximum number of iterations.");
        return rts;
    }
}

