/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.text.DecimalFormat;
import java.util.Arrays;
import smile.util.HtmlCharacter;

public interface Strings {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.####");

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String unescape(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        while (true) {
            block18: {
                int ch;
                block16: {
                    char nextChar;
                    block17: {
                        if (i >= s.length()) {
                            return sb.toString();
                        }
                        ch = s.charAt(i);
                        if (ch != 92) break block16;
                        char c = nextChar = i == s.length() - 1 ? (char)'\\' : (char)s.charAt(i + 1);
                        if (nextChar < 48 || nextChar > 55) break block17;
                        Object code = String.valueOf(nextChar);
                        if (++i < s.length() - 1 && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                            code = (String)code + s.charAt(i + 1);
                            if (++i < s.length() - 1 && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '7') {
                                code = (String)code + s.charAt(i + 1);
                                ++i;
                            }
                        }
                        sb.append((char)Integer.parseInt((String)code, 8));
                        break block18;
                    }
                    switch (nextChar) {
                        case '\\': {
                            ch = 92;
                            break;
                        }
                        case 'b': {
                            ch = 8;
                            break;
                        }
                        case 'f': {
                            ch = 12;
                            break;
                        }
                        case 'n': {
                            ch = 10;
                            break;
                        }
                        case 'r': {
                            ch = 13;
                            break;
                        }
                        case 't': {
                            ch = 9;
                            break;
                        }
                        case '\"': {
                            ch = 34;
                            break;
                        }
                        case '\'': {
                            ch = 39;
                            break;
                        }
                        case 'u': {
                            if (i >= s.length() - 5) {
                                ch = 117;
                                break;
                            }
                            int code = Integer.parseInt(s.substring(i + 2, i + 6), 16);
                            sb.append(Character.toChars(code));
                            i += 5;
                            break block18;
                        }
                    }
                    ++i;
                }
                sb.append((char)ch);
            }
            ++i;
        }
    }

    public static String htmlEscape(String input) {
        return Strings.htmlEscape(input, "ISO-8859-1");
    }

    public static String htmlEscape(String input, String encoding) {
        HtmlCharacter html = new HtmlCharacter();
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            String reference = html.escape(character, encoding);
            if (reference != null) {
                escaped.append(reference);
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String ordinal(int i) {
        String[] suffixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        return switch (i % 100) {
            case 11, 12, 13 -> i + "th";
            default -> i + suffixes[i % 10];
        };
    }

    public static String leftPad(String s, int size, char padChar) {
        if (s == null) {
            return null;
        }
        int pads = size - s.length();
        if (pads <= 0) {
            return s;
        }
        return Strings.fill(padChar, pads).concat(s);
    }

    public static String rightPad(String s, int size, char padChar) {
        if (s == null) {
            return null;
        }
        int pads = size - s.length();
        if (pads <= 0) {
            return s;
        }
        return s.concat(Strings.fill(padChar, pads));
    }

    public static String fill(char ch, int len) {
        char[] chars = new char[len];
        Arrays.fill(chars, ch);
        return new String(chars);
    }

    public static String format(float x) {
        return x == (float)((long)x) ? String.format("%d", (long)x) : String.format("%s", Float.valueOf(x));
    }

    public static String format(double x) {
        return x == (double)((long)x) ? String.format("%d", (long)x) : String.format("%s", x);
    }

    public static int[] parseIntArray(String s) {
        if (Strings.isNullOrEmpty(s)) {
            return null;
        }
        if (!(s = s.trim()).startsWith("[") || !s.endsWith("]")) {
            throw new IllegalArgumentException("Invalid string: " + s);
        }
        String[] tokens = s.substring(1, s.length() - 1).split(",");
        return Arrays.stream(tokens).map(String::trim).mapToInt(Integer::parseInt).toArray();
    }

    public static double[] parseDoubleArray(String s) {
        if (Strings.isNullOrEmpty(s)) {
            return null;
        }
        if (!(s = s.trim()).startsWith("[") || !s.endsWith("]")) {
            throw new IllegalArgumentException("Invalid string: " + s);
        }
        String[] tokens = s.substring(1, s.length() - 1).split(",");
        return Arrays.stream(tokens).map(String::trim).mapToDouble(Double::parseDouble).toArray();
    }
}

