/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;

public class PairingHeap<E extends Comparable<E>>
implements Queue<E> {
    private Node root = null;
    private int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Node addNode(E value) {
        ++this.size;
        Node node = new Node(this, value);
        this.root = this.root == null ? node : this.meld(this.root, node);
        return node;
    }

    public void rebuild() {
        if (this.root == null) {
            return;
        }
        Node node = this.root;
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.offer(node.child);
        node.child = null;
        while (!queue.isEmpty()) {
            node = (Node)queue.poll();
            if (node.sibling != null) {
                queue.offer(node.sibling);
            }
            if (node.child != null) {
                queue.offer(node.child);
            }
            node.child = null;
            node.sibling = null;
            node.parent = null;
            this.root = this.meld(this.root, node);
        }
    }

    @Override
    public boolean add(E value) {
        this.addNode(value);
        return true;
    }

    @Override
    public boolean offer(E value) {
        return this.add(value);
    }

    @Override
    public E peek() {
        return this.root == null ? null : (E)this.root.value;
    }

    @Override
    public E element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.root.value;
    }

    @Override
    public E poll() {
        return (E)(this.isEmpty() ? null : this.remove());
    }

    @Override
    public E remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object value = this.root.value;
        this.root = this.root.child == null ? null : this.twoPassMeld(this.root.child);
        --this.size;
        return value;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (Comparable e : c) {
            this.add((E)e);
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    private Node meld(Node a, Node b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.value.compareTo(b.value) < 0) {
            a.addChild(b);
            return a;
        }
        b.addChild(a);
        return b;
    }

    private Node twoPassMeld(Node start) {
        if (start == null || start.sibling == null) {
            return start;
        }
        start.parent = null;
        Node a = start;
        Node b = start.sibling;
        start = b.sibling;
        a.sibling = null;
        b.sibling = null;
        return this.meld(this.meld(a, b), this.twoPassMeld(start));
    }

    private void cutMeld(Node node) {
        if (node.parent != null && node.value.compareTo(node.parent.value) < 0) {
            Node left = node.parent.child;
            if (left == node) {
                node.parent.child = node.sibling;
            } else {
                while (left.sibling != node) {
                    left = left.sibling;
                }
                left.sibling = node.sibling;
            }
            node.parent = null;
            node.sibling = null;
            this.root = this.meld(this.root, node);
        }
    }

    public class Node {
        E value;
        Node child;
        Node sibling;
        Node parent;
        final /* synthetic */ PairingHeap this$0;

        public Node(E value) {
            reference v0 = this$0;
            Objects.requireNonNull(v0);
            this.this$0 = v0;
            this.child = null;
            this.sibling = null;
            this.parent = null;
            this.value = value;
        }

        public void decrease(E newValue) {
            if (newValue.compareTo(this.value) >= 0) {
                throw new IllegalArgumentException("New value is not more extreme");
            }
            this.value = newValue;
            this.this$0.cutMeld(this);
        }

        void addChild(Node node) {
            node.parent = this;
            node.sibling = this.child;
            this.child = node;
        }
    }
}

