/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import smile.math.MathEx;

public class IntSet
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final int[] values;
    protected final Map<Integer, Integer> index;
    public final int min;
    public final int max;

    public IntSet(int[] values) {
        this.values = values;
        this.min = MathEx.min(values);
        this.max = MathEx.max(values);
        this.index = new HashMap<Integer, Integer>();
        for (int i = 0; i < values.length; ++i) {
            this.index.put(values[i], i);
        }
    }

    public int size() {
        return this.values.length;
    }

    public int valueOf(int index) {
        return this.values[index];
    }

    public int indexOf(int value) {
        return this.index.get(value);
    }

    public static IntSet of(int k) {
        int[] values = IntStream.range(0, k).toArray();
        return new IntSet(values);
    }

    public static IntSet of(int[] samples) {
        int[] values = MathEx.unique(samples);
        Arrays.sort(values);
        return new IntSet(values);
    }
}

