/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Scanner;
import smile.linalg.Transpose;
import smile.linalg.UPLO;
import smile.tensor.AbstractTensor;
import smile.tensor.DenseMatrix;
import smile.tensor.ScalarType;
import smile.tensor.SparseMatrix;
import smile.tensor.SymmMatrix;
import smile.tensor.Tensor;
import smile.tensor.Vector;
import smile.util.SparseArray;

public interface Matrix
extends Tensor {
    public int nrow();

    public int ncol();

    @Override
    default public int dim() {
        return 2;
    }

    @Override
    default public int size(int dim) {
        return switch (dim) {
            case 0 -> this.nrow();
            case 1 -> this.ncol();
            default -> throw new IllegalArgumentException("Invalid dim: " + dim);
        };
    }

    @Override
    default public long length() {
        return (long)this.nrow() * (long)this.ncol();
    }

    @Override
    default public int[] shape() {
        return new int[]{this.nrow(), this.ncol()};
    }

    @Override
    default public Tensor reshape(int ... shape) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public Tensor set(Tensor value, int ... index) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public Tensor get(int ... index) {
        throw new UnsupportedOperationException();
    }

    default public String toString(boolean full) {
        return full ? this.toString(this.nrow(), this.ncol()) : this.toString(7, 7);
    }

    default public String toString(int m, int n) {
        m = Math.min(m, this.nrow());
        n = Math.min(n, this.ncol());
        StringBuilder sb = new StringBuilder(this.nrow() + " x " + this.ncol() + "\n");
        String newline = n < this.ncol() ? "  ...\n" : "\n";
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                sb.append(String.format(" %12.12s", AbstractTensor.format(this.get(i, j))));
            }
            sb.append(newline);
        }
        if (m < this.nrow()) {
            sb.append("  ...\n");
        }
        return sb.toString();
    }

    default public Vector vector(int size) {
        return switch (this.scalarType()) {
            case ScalarType.Float32 -> Vector.column(new float[size]);
            case ScalarType.Float64 -> Vector.column(new double[size]);
            default -> throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)this.scalarType()));
        };
    }

    default public Vector vector(double[] x) {
        return switch (this.scalarType()) {
            case ScalarType.Float64 -> Vector.column(x);
            case ScalarType.Float32 -> {
                Vector v = Vector.column(new float[x.length]);
                for (int i = 0; i < x.length; ++i) {
                    v.set(i, x[i]);
                }
                yield v;
            }
            default -> throw new UnsupportedOperationException("Unsupported ScalarType: " + String.valueOf((Object)this.scalarType()));
        };
    }

    default public Vector vector(float[] x) {
        return switch (this.scalarType()) {
            case ScalarType.Float32 -> Vector.column(x);
            case ScalarType.Float64 -> {
                Vector v = Vector.column(new double[x.length]);
                for (int i = 0; i < x.length; ++i) {
                    v.set(i, x[i]);
                }
                yield v;
            }
            default -> throw new UnsupportedOperationException("Unsupported ScalarType: " + String.valueOf((Object)this.scalarType()));
        };
    }

    public double get(int var1, int var2);

    default public double apply(int i, int j) {
        return this.get(i, j);
    }

    public void set(int var1, int var2, double var3);

    default public void update(int i, int j, double x) {
        this.set(i, j, x);
    }

    public void add(int var1, int var2, double var3);

    public void sub(int var1, int var2, double var3);

    public void mul(int var1, int var2, double var3);

    public void div(int var1, int var2, double var3);

    public Matrix scale(double var1);

    default public Vector diagonal() {
        int n = Math.min(this.nrow(), this.ncol());
        return switch (this.scalarType()) {
            case ScalarType.Float64 -> {
                double[] diag = new double[n];
                for (int i = 0; i < n; ++i) {
                    diag[i] = this.get(i, i);
                }
                yield Vector.column(diag);
            }
            case ScalarType.Float32 -> {
                float[] diag = new float[n];
                for (int i = 0; i < n; ++i) {
                    diag[i] = (float)this.get(i, i);
                }
                yield Vector.column(diag);
            }
            default -> throw new UnsupportedOperationException("Unsupported scalar type: " + String.valueOf((Object)this.scalarType()));
        };
    }

    default public double trace() {
        int n = Math.min(this.nrow(), this.ncol());
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += this.get(i, i);
        }
        return sum;
    }

    default public double[][] toArray(double[][] a) {
        int m = this.nrow();
        int n = this.ncol();
        if (a.length < m || a[0].length < n) {
            a = new double[m][n];
        }
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                a[i][j] = this.get(i, j);
            }
        }
        return a;
    }

    default public float[][] toArray(float[][] a) {
        int m = this.nrow();
        int n = this.ncol();
        if (a.length < m || a[0].length < n) {
            a = new float[m][n];
        }
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                a[i][j] = (float)this.get(i, j);
            }
        }
        return a;
    }

    public Matrix copy();

    public Matrix transpose();

    public void mv(Transpose var1, double var2, Vector var4, double var5, Vector var7);

    default public Vector mv(Vector x) {
        if (this.ncol() > x.size()) {
            throw new IllegalArgumentException(String.format("Dimensions do not match for matrix-vector multiplication A * x: %d x %d vs %d x 1", this.nrow(), this.ncol(), x.size()));
        }
        Vector y = this.vector(this.nrow());
        this.mv(Transpose.NO_TRANSPOSE, 1.0, x, 0.0, y);
        return y;
    }

    default public void mv(Vector x, Vector y) {
        if (this.ncol() > x.size()) {
            throw new IllegalArgumentException(String.format("Dimensions do not match for matrix-vector multiplication A * x: %d x %d vs %d x 1", this.nrow(), this.ncol(), x.size()));
        }
        if (this.nrow() > y.size()) {
            throw new IllegalArgumentException(String.format("Dimensions do not match for matrix-vector multiplication y = A * x: %d x %d vs %d x 1", this.nrow(), this.ncol(), y.size()));
        }
        this.mv(Transpose.NO_TRANSPOSE, 1.0, x, 0.0, y);
    }

    default public void mv(Vector work, int inputOffset, int outputOffset) {
        Vector xb = work.slice(inputOffset, inputOffset + this.ncol());
        Vector yb = work.slice(outputOffset, outputOffset + this.nrow());
        this.mv(Transpose.NO_TRANSPOSE, 1.0, xb, 0.0, yb);
    }

    default public Vector tv(Vector x) {
        if (this.nrow() > x.size()) {
            throw new IllegalArgumentException(String.format("Dimensions do not match for matrix-vector multiplication A' * x: %d x %d vs %d x 1", this.nrow(), this.ncol(), x.size()));
        }
        Vector y = this.vector(this.ncol());
        this.mv(Transpose.TRANSPOSE, 1.0, x, 0.0, y);
        return y;
    }

    default public void tv(Vector x, Vector y) {
        if (this.nrow() > x.size()) {
            throw new IllegalArgumentException(String.format("Dimensions do not match for matrix-vector multiplication A' * x: %d x %d vs %d x 1", this.nrow(), this.ncol(), x.size()));
        }
        if (this.ncol() > y.size()) {
            throw new IllegalArgumentException(String.format("Dimensions do not match for matrix-vector multiplication y = A' * x: %d x %d vs %d x 1", this.nrow(), this.ncol(), y.size()));
        }
        this.mv(Transpose.TRANSPOSE, 1.0, x, 0.0, y);
    }

    default public void tv(Vector work, int inputOffset, int outputOffset) {
        Vector xb = work.slice(inputOffset, inputOffset + this.nrow());
        Vector yb = work.slice(outputOffset, outputOffset + this.ncol());
        this.mv(Transpose.TRANSPOSE, 1.0, xb, 0.0, yb);
    }

    default public Vector mv(double[] x) {
        return this.mv(this.vector(x));
    }

    default public Vector mv(float[] x) {
        return this.mv(this.vector(x));
    }

    default public Vector tv(double[] x) {
        return this.tv(this.vector(x));
    }

    default public Vector tv(float[] x) {
        return this.tv(this.vector(x));
    }

    default public double xAx(Vector x) {
        if (this.nrow() != this.ncol()) {
            throw new IllegalArgumentException(String.format("The matrix is not square: %d x %d", this.nrow(), this.ncol()));
        }
        if (this.ncol() != x.size()) {
            throw new IllegalArgumentException(String.format("Matrix: %d x %d, Vector: %d", this.nrow(), this.ncol(), x.size()));
        }
        Vector Ax = this.mv(x);
        return x.dot(Ax);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Matrix market(Path path) throws IOException, ParseException {
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(path));
             Scanner scanner = new Scanner(reader);){
            int i;
            ArrayList<SparseArray> rows;
            int[] colSize;
            int nz;
            int ncol;
            int nrow;
            String line;
            boolean skew;
            boolean symmetric;
            block48: {
                block47: {
                    block45: {
                        DenseMatrix matrix;
                        int ncol2;
                        int nrow2;
                        block43: {
                            block46: {
                                block44: {
                                    String format;
                                    block42: {
                                        String header = scanner.next();
                                        if (!header.equals("%%MatrixMarket")) {
                                            throw new ParseException("Invalid Matrix Market file header", reader.getLineNumber());
                                        }
                                        String object = scanner.next();
                                        if (!object.equals("matrix")) {
                                            throw new UnsupportedOperationException("The object is not a matrix file: " + object);
                                        }
                                        format = scanner.next();
                                        String field = scanner.next();
                                        if (field.equals("complex")) throw new UnsupportedOperationException("No support of complex or pattern matrix");
                                        if (field.equals("pattern")) {
                                            throw new UnsupportedOperationException("No support of complex or pattern matrix");
                                        }
                                        String symmetry = scanner.nextLine().trim();
                                        if (symmetry.equals("Hermitian")) {
                                            throw new UnsupportedOperationException("No support of Hermitian matrix");
                                        }
                                        symmetric = symmetry.equals("symmetric");
                                        skew = symmetry.equals("skew-symmetric");
                                        line = scanner.nextLine();
                                        while (line.startsWith("%")) {
                                            line = scanner.nextLine();
                                        }
                                        if (!format.equals("array")) break block42;
                                        Scanner s = new Scanner(line);
                                        nrow2 = s.nextInt();
                                        ncol2 = s.nextInt();
                                        matrix = DenseMatrix.zeros(ScalarType.Float64, nrow2, ncol2);
                                        break block43;
                                    }
                                    if (!format.equals("coordinate")) throw new ParseException("Invalid Matrix Market format: " + format, 0);
                                    Scanner s = new Scanner(line);
                                    nrow = s.nextInt();
                                    ncol = s.nextInt();
                                    nz = s.nextInt();
                                    if (!symmetric || nz != nrow * (nrow + 1) / 2) break block44;
                                    if (nrow != ncol) {
                                        throw new IllegalStateException(String.format("Symmetric matrix is not square: %d != %d", nrow, ncol));
                                    }
                                    break block45;
                                }
                                if (!skew || nz != nrow * (nrow + 1) / 2) break block46;
                                if (nrow != ncol) {
                                    throw new IllegalStateException(String.format("Skew-symmetric matrix is not square: %d != %d", nrow, ncol));
                                }
                                break block47;
                            }
                            colSize = new int[ncol];
                            rows = new ArrayList<SparseArray>();
                            for (int i2 = 0; i2 < nrow; ++i2) {
                                rows.add(new SparseArray());
                            }
                            break block48;
                        }
                        for (int j = 0; j < ncol2; ++j) {
                            for (int i3 = 0; i3 < nrow2; ++i3) {
                                double x = scanner.nextDouble();
                                matrix.set(i3, j, x);
                            }
                        }
                        if (symmetric) {
                            matrix.withUplo(UPLO.LOWER);
                        }
                        DenseMatrix j = matrix;
                        return j;
                    }
                    SymmMatrix matrix = SymmMatrix.zeros(ScalarType.Float64, UPLO.LOWER, nrow);
                    int k2 = 0;
                    while (true) {
                        if (k2 >= nz) {
                            SymmMatrix k2 = matrix;
                            return k2;
                        }
                        String[] tokens = scanner.nextLine().trim().split("\\s+");
                        if (tokens.length != 3) {
                            throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                        }
                        int i4 = Integer.parseInt(tokens[0]) - 1;
                        int j = Integer.parseInt(tokens[1]) - 1;
                        double x = Double.parseDouble(tokens[2]);
                        matrix.set(i4, j, x);
                        ++k2;
                    }
                }
                DenseMatrix matrix = DenseMatrix.zeros(ScalarType.Float64, nrow, ncol);
                int k3 = 0;
                while (true) {
                    if (k3 >= nz) {
                        DenseMatrix k3 = matrix;
                        return k3;
                    }
                    String[] tokens = scanner.nextLine().trim().split("\\s+");
                    if (tokens.length != 3) {
                        throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                    }
                    int i5 = Integer.parseInt(tokens[0]) - 1;
                    int j = Integer.parseInt(tokens[1]) - 1;
                    double x = Double.parseDouble(tokens[2]);
                    matrix.set(i5, j, x);
                    matrix.set(j, i5, -x);
                    ++k3;
                }
            }
            for (int k = 0; k < nz; ++k) {
                String[] tokens = scanner.nextLine().trim().split("\\s+");
                if (tokens.length != 3) {
                    throw new ParseException("Invalid data line: " + line, reader.getLineNumber());
                }
                i = Integer.parseInt(tokens[0]) - 1;
                int j = Integer.parseInt(tokens[1]) - 1;
                double x = Double.parseDouble(tokens[2]);
                SparseArray row = (SparseArray)rows.get(i);
                row.set(j, x);
                int n = j;
                colSize[n] = colSize[n] + 1;
                if (symmetric) {
                    row = (SparseArray)rows.get(j);
                    row.set(i, x);
                    int n2 = i;
                    colSize[n2] = colSize[n2] + 1;
                    continue;
                }
                if (!skew) continue;
                row = (SparseArray)rows.get(j);
                row.set(i, -x);
                int n3 = i;
                colSize[n3] = colSize[n3] + 1;
            }
            int[] pos = new int[ncol];
            int[] colIndex = new int[ncol + 1];
            for (i = 0; i < ncol; ++i) {
                colIndex[i + 1] = colIndex[i] + colSize[i];
            }
            if (symmetric || skew) {
                nz *= 2;
            }
            int[] rowIndex = new int[nz];
            double[] x = new double[nz];
            for (int i6 = 0; i6 < nrow; ++i6) {
                for (SparseArray.Entry e : (SparseArray)rows.get(i6)) {
                    int j = e.index();
                    int k = colIndex[j] + pos[j];
                    rowIndex[k] = i6;
                    x[k] = e.value();
                    int n = j;
                    pos[n] = pos[n] + 1;
                }
            }
            SparseMatrix sparseMatrix = new SparseMatrix(nrow, ncol, x, rowIndex, colIndex);
            return sparseMatrix;
        }
    }
}

