/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import smile.math.MathEx;
import smile.tensor.Tensor;

public abstract class AbstractTensor
implements Tensor {
    final int[] shape;
    final long[] stride;

    public AbstractTensor(int ... shape) {
        this.shape = shape;
        int dim = shape.length;
        this.stride = new long[dim];
        this.stride[dim - 1] = 1L;
        for (int i = dim - 2; i >= 0; --i) {
            this.stride[i] = (long)shape[i + 1] * this.stride[i + 1];
        }
    }

    static String format(double x) {
        if (MathEx.isZero(x, (double)1.0E-7f)) {
            return "0.0000";
        }
        double ax = Math.abs(x);
        if (ax >= 0.001 && ax < 1.0E7) {
            return String.format("%.4f", x);
        }
        return String.format("%.4e", x);
    }

    @Override
    public int dim() {
        return this.shape.length;
    }

    @Override
    public int size(int dim) {
        return this.shape[dim];
    }

    @Override
    public int[] shape() {
        return this.shape;
    }

    long offset(int[] index) {
        long offset = 0L;
        for (int i = 0; i < index.length; ++i) {
            offset += (long)index[i] * this.stride[i];
        }
        return offset;
    }
}

