/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.hypothesis;

import smile.math.MathEx;
import smile.math.special.Beta;
import smile.math.special.Erf;
import smile.sort.QuickSort;

public record CorTest(String method, double cor, double t, double df, double pvalue) {
    @Override
    public String toString() {
        return String.format("%s Correlation Test(cor = %.2f, t = %.4f, df = %.3f, p-value = %G)", this.method, this.cor, this.t, this.df, this.pvalue);
    }

    public static CorTest pearson(double[] x, double[] y) {
        int j;
        double TINY = 1.0E-16;
        int n = x.length;
        double syy = 0.0;
        double sxy = 0.0;
        double sxx = 0.0;
        double ay = 0.0;
        double ax = 0.0;
        for (j = 0; j < n; ++j) {
            ax += x[j];
            ay += y[j];
        }
        ax /= (double)n;
        ay /= (double)n;
        for (j = 0; j < n; ++j) {
            double xt = x[j] - ax;
            double yt = y[j] - ay;
            sxx += xt * xt;
            syy += yt * yt;
            sxy += xt * yt;
        }
        double r = sxy / (Math.sqrt(sxx * syy) + 1.0E-16);
        int df = n - 2;
        double t2 = r * Math.sqrt((double)df / ((1.0 - r + 1.0E-16) * (1.0 + r + 1.0E-16)));
        double pvalue = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t2 * t2));
        return new CorTest("Pearson", r, t2, df, pvalue);
    }

    private static double crank(double[] w) {
        int n = w.length;
        double s = 0.0;
        int j = 1;
        while (j < n) {
            int jt;
            if (w[j] != w[j - 1]) {
                w[j - 1] = j;
                ++j;
                continue;
            }
            for (jt = j + 1; jt <= n && w[jt - 1] == w[j - 1]; ++jt) {
            }
            double rank = 0.5 * (double)(j + jt - 1);
            for (int ji = j; ji <= jt - 1; ++ji) {
                w[ji - 1] = rank;
            }
            double t2 = jt - j;
            s += t2 * t2 * t2 - t2;
            j = jt;
        }
        if (j == n) {
            w[n - 1] = n;
        }
        return s;
    }

    public static CorTest spearman(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vectors have different size");
        }
        int n = x.length;
        double[] wksp1 = new double[n];
        double[] wksp2 = new double[n];
        for (int j = 0; j < n; ++j) {
            wksp1[j] = x[j];
            wksp2[j] = y[j];
        }
        QuickSort.sort(wksp1, wksp2);
        double sf = CorTest.crank(wksp1);
        QuickSort.sort(wksp2, wksp1);
        double sg = CorTest.crank(wksp2);
        double d = 0.0;
        for (int j = 0; j < n; ++j) {
            d += MathEx.pow2(wksp1[j] - wksp2[j]);
        }
        double en3n = n * n * n - n;
        double fac = (1.0 - sf / en3n) * (1.0 - sg / en3n);
        double rs = (1.0 - 6.0 / en3n * (d + (sf + sg) / 12.0)) / Math.sqrt(fac);
        fac = (rs + 1.0) * (1.0 - rs);
        double pvalue = 0.0;
        double t2 = rs * Math.sqrt(((double)n - 2.0) / fac);
        int df = n - 2;
        if (fac > 0.0) {
            pvalue = Beta.regularizedIncompleteBetaFunction(0.5 * (double)df, 0.5, (double)df / ((double)df + t2 * t2));
        }
        return new CorTest("Spearman", rs, t2, df, pvalue);
    }

    public static CorTest kendall(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Input vectors have different size");
        }
        int is = 0;
        int n2 = 0;
        int n1 = 0;
        int n = x.length;
        for (int j = 0; j < n - 1; ++j) {
            for (int k = j + 1; k < n; ++k) {
                double a1 = x[j] - x[k];
                double a2 = y[j] - y[k];
                double aa = a1 * a2;
                if (aa != 0.0) {
                    ++n1;
                    ++n2;
                    if (aa > 0.0) {
                        ++is;
                        continue;
                    }
                    --is;
                    continue;
                }
                if (a1 != 0.0) {
                    ++n1;
                }
                if (a2 == 0.0) continue;
                ++n2;
            }
        }
        double tau = (double)is / (Math.sqrt(n1) * Math.sqrt(n2));
        double var = (4.0 * (double)n + 10.0) / (9.0 * (double)n * ((double)n - 1.0));
        double z = tau / Math.sqrt(var);
        double pvalue = Erf.erfcc(Math.abs(z) / 1.4142136);
        return new CorTest("Kendall", tau, z, 0.0, pvalue);
    }
}

