/*
 * Decompiled with CFR 0.152.
 */
package smile.math.rbf;

import smile.math.rbf.RadialBasisFunction;

public class GaussianRadialBasis
implements RadialBasisFunction {
    private static final long serialVersionUID = 1L;
    private final double r0;

    public GaussianRadialBasis() {
        this(1.0);
    }

    public GaussianRadialBasis(double scale) {
        this.r0 = scale;
    }

    @Override
    public double f(double r) {
        return Math.exp(-0.5 * (r /= this.r0) * r);
    }

    public String toString() {
        return String.format("Gaussian Radial Basis (r0 = %.4f)", this.r0);
    }
}

