/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.kernel.IsotropicKernel;

public class Laplacian
implements IsotropicKernel {
    private static final long serialVersionUID = 2L;
    final double sigma;
    final double lo;
    final double hi;

    public Laplacian(double sigma, double lo, double hi) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("sigma is not positive: " + sigma);
        }
        this.sigma = sigma;
        this.lo = lo;
        this.hi = hi;
    }

    public double scale() {
        return this.sigma;
    }

    public String toString() {
        return String.format("LaplacianKernel(%.4f)", this.sigma);
    }

    @Override
    public double k(double dist) {
        return Math.exp(-dist / this.sigma);
    }

    @Override
    public double[] kg(double dist) {
        double k;
        double[] g = new double[2];
        double d = dist / this.sigma;
        g[0] = k = Math.exp(-d);
        g[1] = k * d / this.sigma;
        return g;
    }
}

