/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.kernel.LinearKernel;
import smile.math.kernel.MercerKernel;

public class HellingerKernel
implements MercerKernel<double[]> {
    private static final long serialVersionUID = 2L;

    public String toString() {
        return "HellingerKernel()";
    }

    @Override
    public double k(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += Math.sqrt(x[i] * y[i]);
        }
        return sum;
    }

    @Override
    public double[] kg(double[] x, double[] y) {
        return new double[]{this.k(x, y)};
    }

    public LinearKernel of(double[] params) {
        return new LinearKernel();
    }

    @Override
    public double[] hyperparameters() {
        return new double[0];
    }

    @Override
    public double[] lo() {
        return new double[0];
    }

    @Override
    public double[] hi() {
        return new double[0];
    }
}

