/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.math.MathEx;
import smile.math.kernel.Gaussian;
import smile.math.kernel.MercerKernel;

public class GaussianKernel
extends Gaussian
implements MercerKernel<double[]> {
    public GaussianKernel(double sigma) {
        this(sigma, 1.0E-5, 100000.0);
    }

    public GaussianKernel(double sigma, double lo, double hi) {
        super(sigma, lo, hi);
    }

    @Override
    public double k(double[] x, double[] y) {
        return this.k(MathEx.distance(x, y));
    }

    @Override
    public double[] kg(double[] x, double[] y) {
        return this.kg(MathEx.distance(x, y));
    }

    public GaussianKernel of(double[] params) {
        return new GaussianKernel(params[0], this.lo, this.hi);
    }

    @Override
    public double[] hyperparameters() {
        return new double[]{this.sigma};
    }

    @Override
    public double[] lo() {
        return new double[]{this.lo};
    }

    @Override
    public double[] hi() {
        return new double[]{this.hi};
    }
}

