/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import smile.math.MathEx;
import smile.math.distance.Metric;
import smile.util.IntArray2D;

public class EditDistance
implements Metric<String> {
    private static final long serialVersionUID = 1L;
    private IntArray2D weight;
    private double r = -1.0;
    private boolean damerau = false;
    private IntArray2D FKP;
    private BRF brf;

    public EditDistance() {
        this(false);
    }

    public EditDistance(boolean damerau) {
        this.damerau = damerau;
    }

    public EditDistance(int maxStringLength) {
        this(maxStringLength, false);
    }

    public EditDistance(int maxStringLength, boolean damerau) {
        this.damerau = damerau;
        this.FKP = new IntArray2D(2 * maxStringLength + 1, maxStringLength + 2);
        this.brf = damerau ? new DamerauBRF() : new LevenshteinBRF();
    }

    public EditDistance(int[][] weight) {
        this(weight, -1.0);
    }

    public EditDistance(int[][] weight, double radius) {
        this.weight = new IntArray2D(weight);
        this.r = radius;
    }

    public String toString() {
        if (this.damerau) {
            if (this.weight != null) {
                return String.format("Damerau-Levenshtein Distance(radius = %f, weight = %s)", this.r, this.weight);
            }
            return "Damerau-Levenshtein Distance";
        }
        if (this.weight != null) {
            return String.format("Levenshtein Distance(radius = %f, weight = %s)", this.r, this.weight);
        }
        return "Levenshtein Distance";
    }

    @Override
    public double d(String a, String b) {
        if (this.weight != null) {
            return this.weightedEdit(a, b);
        }
        if (this.FKP == null || a.length() == 1 || b.length() == 1) {
            return this.damerau ? (double)EditDistance.damerau(a, b) : (double)EditDistance.levenshtein(a, b);
        }
        return this.br(a, b);
    }

    @Override
    public double d(char[] a, char[] b) {
        if (this.weight != null) {
            return this.weightedEdit(a, b);
        }
        if (this.FKP == null || a.length == 1 || b.length == 1) {
            return this.damerau ? (double)EditDistance.damerau(a, b) : (double)EditDistance.levenshtein(a, b);
        }
        return this.br(a, b);
    }

    private double weightedEdit(char[] a, char[] b) {
        if (a.length < b.length) {
            char[] swap = a;
            a = b;
            b = swap;
        }
        int radius = (int)Math.round(this.r * (double)a.length);
        double[][] d = new double[2][b.length + 1];
        d[0][0] = 0.0;
        for (int j = 1; j <= b.length; ++j) {
            d[0][j] = d[0][j - 1] + (double)this.weight.get(0, b[j]);
        }
        for (int i = 1; i <= a.length; ++i) {
            d[1][0] = d[0][0] + (double)this.weight.get(a[i], 0);
            int start = 1;
            int end = b.length;
            if (radius > 0) {
                start = i - radius;
                if (start > 1) {
                    d[1][start - 1] = Double.POSITIVE_INFINITY;
                } else {
                    start = 1;
                }
                end = i + radius;
                if (end < b.length) {
                    d[1][end + 1] = Double.POSITIVE_INFINITY;
                } else {
                    end = b.length;
                }
            }
            for (int j = start; j <= end; ++j) {
                double cost = this.weight.get(a[i - 1], b[j - 1]);
                d[1][j] = MathEx.min(d[0][j] + (double)this.weight.get(a[i - 1], 0), d[1][j - 1] + (double)this.weight.get(0, b[j - 1]), d[0][j - 1] + cost);
            }
            double[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][b.length];
    }

    private double weightedEdit(String a, String b) {
        if (a.length() < b.length()) {
            String swap = a;
            a = b;
            b = swap;
        }
        int radius = (int)Math.round(this.r * (double)a.length());
        double[][] d = new double[2][b.length() + 1];
        d[0][0] = 0.0;
        for (int j = 1; j <= b.length(); ++j) {
            d[0][j] = d[0][j - 1] + (double)this.weight.get(0, b.charAt(j));
        }
        for (int i = 1; i <= a.length(); ++i) {
            d[1][0] = d[0][0] + (double)this.weight.get(a.charAt(i), 0);
            int start = 1;
            int end = b.length();
            if (radius > 0) {
                start = i - radius;
                if (start > 1) {
                    d[1][start - 1] = Double.POSITIVE_INFINITY;
                } else {
                    start = 1;
                }
                end = i + radius;
                if (end < b.length()) {
                    d[1][end + 1] = Double.POSITIVE_INFINITY;
                } else {
                    end = b.length();
                }
            }
            for (int j = start; j <= end; ++j) {
                double cost = this.weight.get(a.charAt(i - 1), b.charAt(j - 1));
                d[1][j] = MathEx.min(d[0][j] + (double)this.weight.get(a.charAt(i - 1), 0), d[1][j - 1] + (double)this.weight.get(0, b.charAt(j - 1)), d[0][j - 1] + cost);
            }
            double[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][b.length()];
    }

    private int br(char[] a, char[] b) {
        int p;
        int k;
        int n;
        if (a.length > b.length) {
            char[] swap = a;
            a = b;
            b = swap;
        }
        int m = a.length;
        int ZERO_K = n = b.length;
        if (n + 2 > this.FKP.ncol()) {
            this.FKP = new IntArray2D(2 * n + 1, n + 2);
        }
        for (k = -ZERO_K; k < 0; ++k) {
            p = -k - 1;
            this.FKP.set(k + ZERO_K, p + 1, Math.abs(k) - 1);
            this.FKP.set(k + ZERO_K, p, Integer.MIN_VALUE);
        }
        this.FKP.set(ZERO_K, 0, -1);
        for (k = 1; k <= ZERO_K; ++k) {
            p = k - 1;
            this.FKP.set(k + ZERO_K, p + 1, -1);
            this.FKP.set(k + ZERO_K, p, Integer.MIN_VALUE);
        }
        int p2 = n - m - 1;
        do {
            int i;
            for (i = (++p2 - (n - m)) / 2; i >= 1; --i) {
                this.brf.f(a, b, this.FKP, ZERO_K, n - m + i, p2 - i);
            }
            for (i = (n - m + p2) / 2; i >= 1; --i) {
                this.brf.f(a, b, this.FKP, ZERO_K, n - m - i, p2 - i);
            }
            this.brf.f(a, b, this.FKP, ZERO_K, n - m, p2);
        } while (this.FKP.get(n - m + ZERO_K, p2) != m);
        return p2 - 1;
    }

    private int br(String a, String b) {
        int p;
        int k;
        int n;
        if (a.length() > b.length()) {
            String swap = a;
            a = b;
            b = swap;
        }
        int m = a.length();
        int ZERO_K = n = b.length();
        if (n + 3 > this.FKP.ncol()) {
            this.FKP = new IntArray2D(2 * n + 1, n + 3);
        }
        for (k = -ZERO_K; k < 0; ++k) {
            p = -k - 1;
            this.FKP.set(k + ZERO_K, p + 1, Math.abs(k) - 1);
            this.FKP.set(k + ZERO_K, p, Integer.MIN_VALUE);
        }
        this.FKP.set(ZERO_K, 0, -1);
        for (k = 1; k <= ZERO_K; ++k) {
            p = k - 1;
            this.FKP.set(k + ZERO_K, p + 1, -1);
            this.FKP.set(k + ZERO_K, p, Integer.MIN_VALUE);
        }
        int p2 = n - m - 1;
        do {
            int i;
            for (i = (++p2 - (n - m)) / 2; i >= 1; --i) {
                this.brf.f(a, b, this.FKP, ZERO_K, n - m + i, p2 - i);
            }
            for (i = (n - m + p2) / 2; i >= 1; --i) {
                this.brf.f(a, b, this.FKP, ZERO_K, n - m - i, p2 - i);
            }
            this.brf.f(a, b, this.FKP, ZERO_K, n - m, p2);
        } while (this.FKP.get(n - m + ZERO_K, p2) != m);
        return p2 - 1;
    }

    public static int levenshtein(String a, String b) {
        if (a.length() < b.length()) {
            String swap = a;
            a = b;
            b = swap;
        }
        int[][] d = new int[2][b.length() + 1];
        for (int j = 0; j <= b.length(); ++j) {
            d[0][j] = j;
        }
        for (int i = 1; i <= a.length(); ++i) {
            d[1][0] = i;
            for (int j = 1; j <= b.length(); ++j) {
                int cost = a.charAt(i - 1) == b.charAt(j - 1) ? 0 : 1;
                d[1][j] = MathEx.min(d[0][j] + 1, d[1][j - 1] + 1, d[0][j - 1] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][b.length()];
    }

    public static int levenshtein(char[] a, char[] b) {
        if (a.length < b.length) {
            char[] swap = a;
            a = b;
            b = swap;
        }
        int[][] d = new int[2][b.length + 1];
        for (int j = 0; j <= b.length; ++j) {
            d[0][j] = j;
        }
        for (int i = 1; i <= a.length; ++i) {
            d[1][0] = i;
            for (int j = 1; j <= b.length; ++j) {
                int cost = a[i - 1] == b[j - 1] ? 0 : 1;
                d[1][j] = MathEx.min(d[0][j] + 1, d[1][j - 1] + 1, d[0][j - 1] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = swap;
        }
        return d[0][b.length];
    }

    public static int damerau(String a, String b) {
        if (a.length() < b.length()) {
            String swap = a;
            a = b;
            b = swap;
        }
        int[][] d = new int[3][b.length() + 1];
        for (int j = 0; j <= b.length(); ++j) {
            d[1][j] = j;
        }
        for (int i = 1; i <= a.length(); ++i) {
            d[2][0] = i;
            for (int j = 1; j <= b.length(); ++j) {
                int cost = a.charAt(i - 1) == b.charAt(j - 1) ? 0 : 1;
                d[2][j] = MathEx.min(d[1][j] + 1, d[2][j - 1] + 1, d[1][j - 1] + cost);
                if (i <= 1 || j <= 1 || a.charAt(i - 1) != b.charAt(j - 2) || a.charAt(i - 2) != b.charAt(j - 1)) continue;
                d[2][j] = Math.min(d[2][j], d[0][j - 2] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = d[2];
            d[2] = swap;
        }
        return d[1][b.length()];
    }

    public static int damerau(char[] a, char[] b) {
        if (a.length < b.length) {
            char[] swap = a;
            a = b;
            b = swap;
        }
        int[][] d = new int[3][b.length + 1];
        for (int j = 0; j <= b.length; ++j) {
            d[1][j] = j;
        }
        for (int i = 1; i <= a.length; ++i) {
            d[2][0] = i;
            for (int j = 1; j <= b.length; ++j) {
                int cost = a[i - 1] == b[j - 1] ? 0 : 1;
                d[2][j] = MathEx.min(d[1][j] + 1, d[2][j - 1] + 1, d[1][j - 1] + cost);
                if (i <= 1 || j <= 1 || a[i - 1] != b[j - 2] || a[i - 2] != b[j - 1]) continue;
                d[2][j] = Math.min(d[2][j], d[0][j - 2] + cost);
            }
            int[] swap = d[0];
            d[0] = d[1];
            d[1] = d[2];
            d[2] = swap;
        }
        return d[1][b.length];
    }

    private static class DamerauBRF
    implements BRF {
        private DamerauBRF() {
        }

        @Override
        public void f(char[] x, char[] y, IntArray2D FKP, int ZERO_K, int k, int p) {
            int t2 = FKP.get(k + ZERO_K, p) + 1;
            int mnk = Math.min(x.length, y.length - k);
            if (t2 >= 1 && k + t2 >= 1 && t2 < mnk && x[t2 - 1] == y[k + t2] && x[t2] == y[k + t2 - 1]) {
                ++t2;
            }
            for (t2 = MathEx.max(FKP.get(k - 1 + ZERO_K, p), FKP.get(k + 1 + ZERO_K, p) + 1, t2); t2 < mnk && x[t2] == y[t2 + k]; ++t2) {
            }
            FKP.set(k + ZERO_K, p + 1, t2);
        }

        @Override
        public void f(String x, String y, IntArray2D FKP, int ZERO_K, int k, int p) {
            int t2 = FKP.get(k + ZERO_K, p) + 1;
            int mnk = Math.min(x.length(), y.length() - k);
            if (t2 >= 1 && k + t2 >= 1 && t2 < mnk && x.charAt(t2 - 1) == y.charAt(k + t2) && x.charAt(t2) == y.charAt(k + t2 - 1)) {
                ++t2;
            }
            for (t2 = MathEx.max(FKP.get(k - 1 + ZERO_K, p), FKP.get(k + 1 + ZERO_K, p) + 1, t2); t2 < mnk && x.charAt(t2) == y.charAt(t2 + k); ++t2) {
            }
            FKP.set(k + ZERO_K, p + 1, t2);
        }
    }

    private static class LevenshteinBRF
    implements BRF {
        private LevenshteinBRF() {
        }

        @Override
        public void f(char[] x, char[] y, IntArray2D FKP, int ZERO_K, int k, int p) {
            int t2;
            int mnk = Math.min(x.length, y.length - k);
            for (t2 = MathEx.max(FKP.get(k + ZERO_K, p) + 1, FKP.get(k - 1 + ZERO_K, p), FKP.get(k + 1 + ZERO_K, p) + 1); t2 < mnk && x[t2] == y[t2 + k]; ++t2) {
            }
            FKP.set(k + ZERO_K, p + 1, t2);
        }

        @Override
        public void f(String x, String y, IntArray2D FKP, int ZERO_K, int k, int p) {
            int t2;
            int mnk = Math.min(x.length(), y.length() - k);
            for (t2 = MathEx.max(FKP.get(k + ZERO_K, p) + 1, FKP.get(k - 1 + ZERO_K, p), FKP.get(k + 1 + ZERO_K, p) + 1); t2 < mnk && x.charAt(t2) == y.charAt(t2 + k); ++t2) {
            }
            FKP.set(k + ZERO_K, p + 1, t2);
        }
    }

    private static interface BRF {
        public void f(char[] var1, char[] var2, IntArray2D var3, int var4, int var5, int var6);

        public void f(String var1, String var2, IntArray2D var3, int var4, int var5, int var6);
    }
}

