/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

class LocalInputFile
implements InputFile {
    private final RandomAccessFile input;

    public LocalInputFile(Path path) throws FileNotFoundException {
        this.input = new RandomAccessFile(path.toFile(), "r");
    }

    public long getLength() throws IOException {
        return this.input.length();
    }

    public SeekableInputStream newStream() {
        return new SeekableInputStream(this){
            private final byte[] page;
            private long markPos;
            final /* synthetic */ LocalInputFile this$0;
            {
                LocalInputFile localInputFile = this$0;
                Objects.requireNonNull(localInputFile);
                this.this$0 = localInputFile;
                this.page = new byte[8192];
                this.markPos = 0L;
            }

            public int read() throws IOException {
                return this.this$0.input.read();
            }

            public int read(byte[] b) throws IOException {
                return this.this$0.input.read(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return this.this$0.input.read(b, off, len);
            }

            public long skip(long n) throws IOException {
                long savPos = this.this$0.input.getFilePointer();
                long amtLeft = this.this$0.input.length() - savPos;
                n = Math.min(n, amtLeft);
                long newPos = savPos + n;
                this.this$0.input.seek(newPos);
                long curPos = this.this$0.input.getFilePointer();
                return curPos - savPos;
            }

            public int available() {
                return 0;
            }

            public void close() throws IOException {
                this.this$0.input.close();
            }

            private <T extends Throwable, R> R uncheckedExceptionThrow(Throwable t2) throws T {
                throw t2;
            }

            public synchronized void mark(int readlimit) {
                try {
                    this.markPos = this.this$0.input.getFilePointer();
                }
                catch (IOException e) {
                    this.uncheckedExceptionThrow(e);
                }
            }

            public synchronized void reset() throws IOException {
                this.this$0.input.seek(this.markPos);
            }

            public boolean markSupported() {
                return true;
            }

            public long getPos() throws IOException {
                return this.this$0.input.getFilePointer();
            }

            public void seek(long l) throws IOException {
                this.this$0.input.seek(l);
            }

            public void readFully(byte[] bytes) throws IOException {
                this.this$0.input.readFully(bytes);
            }

            public void readFully(byte[] bytes, int i, int i1) throws IOException {
                this.this$0.input.readFully(bytes, i, i1);
            }

            public int read(ByteBuffer byteBuffer) throws IOException {
                return this.this$0.readDirectBuffer(byteBuffer, this.page, this.this$0.input::read);
            }

            public void readFully(ByteBuffer byteBuffer) throws IOException {
                LocalInputFile.readFullyDirectBuffer(byteBuffer, this.page, this.this$0.input::read);
            }
        };
    }

    private int readDirectBuffer(ByteBuffer byteBuffer, byte[] page, ByteBufferReader reader) throws IOException {
        int bytesRead;
        int nextReadLength = Math.min(byteBuffer.remaining(), page.length);
        int totalBytesRead = 0;
        while ((bytesRead = reader.read(page, 0, nextReadLength)) == page.length) {
            byteBuffer.put(page);
            totalBytesRead += bytesRead;
            nextReadLength = Math.min(byteBuffer.remaining(), page.length);
        }
        if (bytesRead < 0) {
            return totalBytesRead == 0 ? -1 : totalBytesRead;
        }
        byteBuffer.put(page, 0, bytesRead);
        return totalBytesRead += bytesRead;
    }

    private static void readFullyDirectBuffer(ByteBuffer byteBuffer, byte[] page, ByteBufferReader reader) throws IOException {
        int nextReadLength = Math.min(byteBuffer.remaining(), page.length);
        int bytesRead = 0;
        while (nextReadLength > 0 && (bytesRead = reader.read(page, 0, nextReadLength)) >= 0) {
            byteBuffer.put(page, 0, bytesRead);
            nextReadLength = Math.min(byteBuffer.remaining(), page.length);
        }
        if (bytesRead < 0 && byteBuffer.remaining() > 0) {
            throw new EOFException("Reached the end of stream with " + byteBuffer.remaining() + " bytes left to read");
        }
    }

    private static interface ByteBufferReader {
        public int read(byte[] var1, int var2, int var3) throws IOException;
    }
}

